/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.packet;

import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class ServerToClientPacket
extends CustomPacket {
    protected ServerToClientPacket(@Nonnull CustomPacketPayload.Type<?> type) {
        super(type);
    }

    public final void sendTo(@Nonnull Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.sendTo(sp);
        }
    }

    public final void sendTo(@Nonnull ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void sendTo(@Nonnull List<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public final void sendToPlayersNear(@Nonnull ServerLevel level, @Nullable ServerPlayer excluded, double x, double y, double z, double radius) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, (ServerPlayer)excluded, (double)x, (double)y, (double)z, (double)radius, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void sendToPlayersInDimension(@Nonnull ServerLevel level) {
        PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void sendToPlayersTrackingChunk(@Nonnull ServerLevel level, @Nonnull ChunkPos chunk) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)chunk, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void sendToPlayersTrackingEntity(@Nonnull Entity entity) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void sendToPlayersTrackingEntityAndSelf(@Nonnull Entity entity) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void sendToAll() {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

