/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.walletslot;

import io.github.lightman314.lightmanscurrency.common.attachments.WalletHandler;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketSetVisible
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketSetVisible> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_wallet_set_visible"));
    public static final CustomPacket.Handler<CPacketSetVisible> HANDLER = new H();
    boolean visible;

    public CPacketSetVisible(boolean visible) {
        super(TYPE);
        this.visible = visible;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CPacketSetVisible message) {
        buffer.writeBoolean(message.visible);
    }

    private static CPacketSetVisible decode(@Nonnull FriendlyByteBuf buffer) {
        return new CPacketSetVisible(buffer.readBoolean());
    }

    private static class H
    extends CustomPacket.Handler<CPacketSetVisible> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(CPacketSetVisible::encode, CPacketSetVisible::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketSetVisible message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            WalletHandler walletHandler = WalletHandler.get((LivingEntity)player);
            if (walletHandler != null) {
                walletHandler.setVisible(message.visible);
            }
        }
    }
}

