/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.walletslot;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.attachments.WalletHandler;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketCreativeWalletEdit
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketCreativeWalletEdit> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_wallet_creative_edit"));
    public static final CustomPacket.Handler<CPacketCreativeWalletEdit> HANDLER = new H();
    private final ItemStack newWallet;

    public CPacketCreativeWalletEdit(@Nonnull ItemStack wallet) {
        super(TYPE);
        this.newWallet = wallet;
    }

    private static void encode(@Nonnull RegistryFriendlyByteBuf buffer, @Nonnull CPacketCreativeWalletEdit message) {
        CPacketCreativeWalletEdit.writeItem(buffer, message.newWallet);
    }

    private static CPacketCreativeWalletEdit decode(@Nonnull RegistryFriendlyByteBuf buffer) {
        return new CPacketCreativeWalletEdit(CPacketCreativeWalletEdit.readItem(buffer));
    }

    private static class H
    extends CustomPacket.Handler<CPacketCreativeWalletEdit> {
        protected H() {
            super(TYPE, CustomPacket.fancyCodec(CPacketCreativeWalletEdit::encode, CPacketCreativeWalletEdit::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketCreativeWalletEdit message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            if (player.isCreative()) {
                WalletHandler walletHandler = WalletHandler.get((LivingEntity)player);
                walletHandler.setWallet(message.newWallet);
            } else {
                LightmansCurrency.LogWarning(player.getName().getString() + " attempted to set their wallet stack from the client, but they're not currently in creative mode!");
            }
        }
    }
}

