/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.trader;

import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketAddOrRemoveTrade
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketAddOrRemoveTrade> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_trader_add_remove_trade"));
    public static final CustomPacket.Handler<CPacketAddOrRemoveTrade> HANDLER = new H();
    long traderID;
    boolean isTradeAdd;

    public CPacketAddOrRemoveTrade(long traderID, boolean isTradeAdd) {
        super(TYPE);
        this.traderID = traderID;
        this.isTradeAdd = isTradeAdd;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CPacketAddOrRemoveTrade message) {
        buffer.writeLong(message.traderID);
        buffer.writeBoolean(message.isTradeAdd);
    }

    private static CPacketAddOrRemoveTrade decode(@Nonnull FriendlyByteBuf buffer) {
        return new CPacketAddOrRemoveTrade(buffer.readLong(), buffer.readBoolean());
    }

    private static class H
    extends CustomPacket.Handler<CPacketAddOrRemoveTrade> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(CPacketAddOrRemoveTrade::encode, CPacketAddOrRemoveTrade::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketAddOrRemoveTrade message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            TraderData trader = TraderAPI.API.GetTrader(false, message.traderID);
            if (trader != null) {
                if (message.isTradeAdd) {
                    trader.addTrade(player);
                } else {
                    trader.removeTrade(player);
                }
            }
        }
    }
}

