/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.notifications;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SPacketChatNotification
extends ServerToClientPacket {
    private static final CustomPacketPayload.Type<SPacketChatNotification> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("s_notification_chat"));
    public static final CustomPacket.Handler<SPacketChatNotification> HANDLER = new H();
    private final Notification notification;

    public SPacketChatNotification(Notification notification) {
        super(TYPE);
        this.notification = notification;
    }

    private static void encode(@Nonnull RegistryFriendlyByteBuf buffer, @Nonnull SPacketChatNotification message) {
        buffer.writeNbt((Tag)message.notification.save((HolderLookup.Provider)buffer.registryAccess()));
    }

    private static SPacketChatNotification decode(@Nonnull RegistryFriendlyByteBuf buffer) {
        return new SPacketChatNotification(NotificationAPI.API.LoadNotification(SPacketChatNotification.readNBT((FriendlyByteBuf)buffer), (HolderLookup.Provider)buffer.registryAccess()));
    }

    private static class H
    extends CustomPacket.Handler<SPacketChatNotification> {
        protected H() {
            super(TYPE, CustomPacket.fancyCodec(SPacketChatNotification::encode, SPacketChatNotification::decode));
        }

        @Override
        protected void handle(@Nonnull SPacketChatNotification message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            LightmansCurrency.getProxy().receiveNotification(message.notification);
        }
    }
}

