/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.menu;

import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.common.menus.LazyMessageMenu;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SPacketLazyMenu
extends ServerToClientPacket {
    private static final CustomPacketPayload.Type<SPacketLazyMenu> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("s_lazy_menu"));
    public static final CustomPacket.Handler<SPacketLazyMenu> HANDLER = new H();
    private final int menuID;
    private final LazyPacketData data;

    public SPacketLazyMenu(int menuID, LazyPacketData data) {
        super(TYPE);
        this.menuID = menuID;
        this.data = data;
    }

    public SPacketLazyMenu(int menuID, LazyPacketData.Builder data) {
        this(menuID, data.build());
    }

    private static void encode(@Nonnull RegistryFriendlyByteBuf buffer, @Nonnull SPacketLazyMenu message) {
        buffer.writeInt(message.menuID);
        message.data.encode(buffer);
    }

    private static SPacketLazyMenu decode(@Nonnull RegistryFriendlyByteBuf buffer) {
        return new SPacketLazyMenu(buffer.readInt(), LazyPacketData.decode(buffer));
    }

    private static class H
    extends CustomPacket.Handler<SPacketLazyMenu> {
        protected H() {
            super(TYPE, CustomPacket.fancyCodec(SPacketLazyMenu::encode, SPacketLazyMenu::decode));
        }

        @Override
        protected void handle(@Nonnull SPacketLazyMenu message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof LazyMessageMenu) {
                LazyMessageMenu menu = (LazyMessageMenu)abstractContainerMenu;
                if (menu.containerId == menu.containerId) {
                    menu.HandleMessage(message.data);
                }
            }
        }
    }
}

