/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.interfacebe;

import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketInterfaceHandlerMessage
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketInterfaceHandlerMessage> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_interface_handler_message"));
    public static final CustomPacket.Handler<CPacketInterfaceHandlerMessage> HANDLER = new H();
    BlockPos pos;
    ResourceLocation type;
    CompoundTag updateInfo;

    public CPacketInterfaceHandlerMessage(BlockPos pos, ResourceLocation type, CompoundTag updateInfo) {
        super(TYPE);
        this.pos = pos;
        this.type = type;
        this.updateInfo = updateInfo;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CPacketInterfaceHandlerMessage message) {
        buffer.writeBlockPos(message.pos);
        buffer.writeUtf(message.type.toString());
        buffer.writeNbt((Tag)message.updateInfo);
    }

    private static CPacketInterfaceHandlerMessage decode(@Nonnull FriendlyByteBuf buffer) {
        return new CPacketInterfaceHandlerMessage(buffer.readBlockPos(), VersionUtil.parseResource(buffer.readUtf()), CPacketInterfaceHandlerMessage.readNBT(buffer));
    }

    private static class H
    extends CustomPacket.Handler<CPacketInterfaceHandlerMessage> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(CPacketInterfaceHandlerMessage::encode, CPacketInterfaceHandlerMessage::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketInterfaceHandlerMessage message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            BlockEntity blockEntity = player.level().getBlockEntity(message.pos);
            if (blockEntity instanceof TraderInterfaceBlockEntity) {
                TraderInterfaceBlockEntity be = (TraderInterfaceBlockEntity)blockEntity;
                be.receiveHandlerMessage(message.type, player, message.updateInfo);
            }
        }
    }
}

