/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.auction;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.auction.AuctionBidTab;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SPacketStartBid
extends ServerToClientPacket {
    private static final CustomPacketPayload.Type<SPacketStartBid> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("s_auction_start_bid"));
    public static final CustomPacket.Handler<SPacketStartBid> HANDLER = new H();
    final long auctionHouseID;
    final int tradeIndex;

    public SPacketStartBid(long auctionHouseID, int tradeIndex) {
        super(TYPE);
        this.auctionHouseID = auctionHouseID;
        this.tradeIndex = tradeIndex;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull SPacketStartBid message) {
        buffer.writeLong(message.auctionHouseID);
        buffer.writeInt(message.tradeIndex);
    }

    private static SPacketStartBid decode(@Nonnull FriendlyByteBuf buffer) {
        return new SPacketStartBid(buffer.readLong(), buffer.readInt());
    }

    private static class H
    extends CustomPacket.Handler<SPacketStartBid> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(SPacketStartBid::encode, SPacketStartBid::decode));
        }

        @Override
        protected void handle(@Nonnull SPacketStartBid message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            Minecraft mc = Minecraft.getInstance();
            Screen screen = mc.screen;
            if (screen instanceof TraderScreen) {
                TraderScreen screen2 = (TraderScreen)screen;
                screen2.setTab(new AuctionBidTab(screen2, message.auctionHouseID, message.tradeIndex));
            }
        }
    }
}

