/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.jeiplugin;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.NotificationScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.CoinChestScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.EjectionRecoveryScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.GachaMachineScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.PlayerTradeScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.SlotMachineScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TaxCollectorScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletBankScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletScreen;
import io.github.lightman314.lightmanscurrency.common.blocks.variant.IVariantBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.crafting.CoinMintRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.RecipeValidator;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketStationRecipe;
import io.github.lightman314.lightmanscurrency.common.items.ancient_coins.AncientCoinType;
import io.github.lightman314.lightmanscurrency.common.menus.MintMenu;
import io.github.lightman314.lightmanscurrency.common.menus.TicketStationMenu;
import io.github.lightman314.lightmanscurrency.integration.jeiplugin.CoinMintCategory;
import io.github.lightman314.lightmanscurrency.integration.jeiplugin.TicketStationCategory;
import io.github.lightman314.lightmanscurrency.integration.jeiplugin.util.JEIScreenArea;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@JeiPlugin
public class LCJeiPlugin
implements IModPlugin {
    public static final RecipeType<CoinMintRecipe> COIN_MINT_TYPE = RecipeType.create((String)"lightmanscurrency", (String)"coin_mint", CoinMintRecipe.class);
    public static final RecipeType<TicketStationRecipe> TICKET_TYPE = RecipeType.create((String)"lightmanscurrency", (String)"ticket_station", TicketStationRecipe.class);

    public ResourceLocation getPluginUid() {
        return VersionUtil.lcResource("lightmanscurrency");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CoinMintCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new TicketStationCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<CoinMintRecipe> mintRecipes = RecipeValidator.getAllMintRecipes((Level)Minecraft.getInstance().level);
        registration.addRecipes(COIN_MINT_TYPE, mintRecipes);
        List<TicketStationRecipe> ticketRecipes = RecipeValidator.getTicketStationRecipeList((Level)Minecraft.getInstance().level);
        registration.addRecipes(TICKET_TYPE, ticketRecipes);
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.TICKET_STUB.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{LCText.JEI_INFO_TICKET_STUB.get(new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.GOLDEN_TICKET_STUB.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{LCText.JEI_INFO_TICKET_STUB.get(new Object[0])});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(ModItems.COIN_ANCIENT.get(), (ISubtypeInterpreter)new AncientCoinSubtype());
        VariantSubtype variantSubtype = new VariantSubtype();
        for (Item item : BuiltInRegistries.ITEM) {
            BlockItem bi;
            if (!(item instanceof BlockItem) || !((bi = (BlockItem)item).getBlock() instanceof IVariantBlock)) continue;
            registration.registerSubtypeInterpreter(item, (ISubtypeInterpreter)variantSubtype);
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration zones) {
        this.registerExclusionZones(zones, TraderScreen.class);
        this.registerExclusionZones(zones, SlotMachineScreen.class);
        this.registerExclusionZones(zones, GachaMachineScreen.class);
        this.registerExclusionZones(zones, TraderStorageScreen.class);
        this.registerExclusionZones(zones, ATMScreen.class);
        this.registerExclusionZones(zones, TaxCollectorScreen.class);
        this.registerExclusionZones(zones, CoinChestScreen.class);
        this.registerExclusionZones(zones, EjectionRecoveryScreen.class);
        this.registerExclusionZones(zones, PlayerTradeScreen.class);
        this.registerExclusionZones(zones, TraderInterfaceScreen.class);
        this.registerExclusionZones(zones, WalletScreen.class);
        this.registerExclusionZones(zones, WalletBankScreen.class);
        this.registerExclusionZones(zones, TeamManagerScreen.class);
        this.registerExclusionZones(zones, NotificationScreen.class);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.COIN_MINT.get()), new RecipeType[]{COIN_MINT_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.TICKET_STATION.get()), new RecipeType[]{TICKET_TYPE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(MintMenu.class, ModMenus.MINT.get(), COIN_MINT_TYPE, 0, 1, 2, 36);
        registration.addRecipeTransferHandler(TicketStationMenu.class, ModMenus.TICKET_MACHINE.get(), TICKET_TYPE, 0, 2, 3, 36);
    }

    private <T extends EasyMenuScreen<?>> void registerExclusionZones(IGuiHandlerRegistration registration, Class<T> clazz) {
        registration.addGuiContainerHandler(clazz, JEIScreenArea.create(clazz, registration.getJeiHelpers().getIngredientManager()));
    }

    private static class AncientCoinSubtype
    implements ISubtypeInterpreter<ItemStack> {
        private AncientCoinSubtype() {
        }

        @Nullable
        public Object getSubtypeData(ItemStack ingredient, UidContext context) {
            return ingredient.getOrDefault(ModDataComponents.ANCIENT_COIN_TYPE, (Object)AncientCoinType.COPPER);
        }

        public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
            return String.valueOf(this.getSubtypeData(ingredient, context));
        }
    }

    private static class VariantSubtype
    implements ISubtypeInterpreter<ItemStack> {
        private VariantSubtype() {
        }

        @Nullable
        public Object getSubtypeData(ItemStack ingredient, UidContext context) {
            return ingredient.getOrDefault(ModDataComponents.MODEL_VARIANT, null);
        }

        public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
            return Objects.toString(this.getSubtypeData(ingredient, context));
        }
    }
}

