/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.util;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.datagen.util.WoodData;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class WoodDataHelper {
    private static final Map<WoodType, WoodData> registeredData = new HashMap<WoodType, WoodData>();

    public static void register(@Nonnull WoodType type, @Nonnull WoodData data) {
        if (registeredData.containsKey(type)) {
            LightmansCurrency.LogError("Attempted to register a duplicate WoodData for type '" + type.id + "'!");
            return;
        }
        registeredData.put(type, Objects.requireNonNull(data));
    }

    @Nullable
    public static WoodData get(WoodType type) {
        return registeredData.get(type);
    }

    static {
        WoodDataHelper.register(WoodType.OAK, WoodData.of((ItemLike)Items.OAK_LOG, (ItemLike)Items.OAK_PLANKS, (ItemLike)Items.OAK_SLAB, "minecraft:block/oak_log", "minecraft:block/oak_log_top", "minecraft:block/oak_planks"));
        WoodDataHelper.register(WoodType.SPRUCE, WoodData.of((ItemLike)Items.SPRUCE_LOG, (ItemLike)Items.SPRUCE_PLANKS, (ItemLike)Items.SPRUCE_SLAB, "minecraft:block/spruce_log", "minecraft:block/spruce_log_top", "minecraft:block/spruce_planks"));
        WoodDataHelper.register(WoodType.BIRCH, WoodData.of((ItemLike)Items.BIRCH_LOG, (ItemLike)Items.BIRCH_PLANKS, (ItemLike)Items.BIRCH_SLAB, "minecraft:block/birch_log", "minecraft:block/birch_log_top", "minecraft:block/birch_planks"));
        WoodDataHelper.register(WoodType.JUNGLE, WoodData.of((ItemLike)Items.JUNGLE_LOG, (ItemLike)Items.JUNGLE_PLANKS, (ItemLike)Items.JUNGLE_SLAB, "minecraft:block/jungle_log", "minecraft:block/jungle_log_top", "minecraft:block/jungle_planks"));
        WoodDataHelper.register(WoodType.ACACIA, WoodData.of((ItemLike)Items.ACACIA_LOG, (ItemLike)Items.ACACIA_PLANKS, (ItemLike)Items.ACACIA_SLAB, "minecraft:block/acacia_log", "minecraft:block/acacia_log_top", "minecraft:block/acacia_planks"));
        WoodDataHelper.register(WoodType.DARK_OAK, WoodData.of((ItemLike)Items.DARK_OAK_LOG, (ItemLike)Items.DARK_OAK_PLANKS, (ItemLike)Items.DARK_OAK_SLAB, "minecraft:block/dark_oak_log", "minecraft:block/dark_oak_log_top", "minecraft:block/dark_oak_planks"));
        WoodDataHelper.register(WoodType.MANGROVE, WoodData.of((ItemLike)Items.MANGROVE_LOG, (ItemLike)Items.MANGROVE_PLANKS, (ItemLike)Items.MANGROVE_SLAB, "minecraft:block/mangrove_log", "minecraft:block/mangrove_log_top", "minecraft:block/mangrove_planks"));
        WoodDataHelper.register(WoodType.CHERRY, WoodData.of((ItemLike)Items.CHERRY_LOG, (ItemLike)Items.CHERRY_PLANKS, (ItemLike)Items.CHERRY_SLAB, "minecraft:block/cherry_log", "minecraft:block/cherry_log_top", "minecraft:block/cherry_planks"));
        WoodDataHelper.register(WoodType.BAMBOO, WoodData.of((ItemLike)Items.BAMBOO_BLOCK, (ItemLike)Items.BAMBOO_PLANKS, (ItemLike)Items.BAMBOO_SLAB, "minecraft:block/bamboo_block", "minecraft:block/bamboo_block_top", "minecraft:block/bamboo_planks"));
        WoodDataHelper.register(WoodType.CRIMSON, WoodData.of((ItemLike)Items.CRIMSON_STEM, (ItemLike)Items.CRIMSON_PLANKS, (ItemLike)Items.CRIMSON_SLAB, "minecraft:block/crimson_stem", "minecraft:block/crimson_stem_top", "minecraft:block/crimson_planks"));
        WoodDataHelper.register(WoodType.WARPED, WoodData.of((ItemLike)Items.WARPED_STEM, (ItemLike)Items.WARPED_PLANKS, (ItemLike)Items.WARPED_SLAB, "minecraft:block/warped_stem", "minecraft:block/warped_stem_top", "minecraft:block/warped_planks"));
    }
}

