/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.util;

import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ColorHelper {
    public static Item GetConcretePowderOfColor(Color color) {
        return switch (color) {
            case Color.LIGHT_GRAY -> Items.LIGHT_GRAY_CONCRETE_POWDER;
            case Color.GRAY -> Items.GRAY_CONCRETE_POWDER;
            case Color.BLACK -> Items.BLACK_CONCRETE_POWDER;
            case Color.BROWN -> Items.BROWN_CONCRETE_POWDER;
            case Color.RED -> Items.RED_CONCRETE_POWDER;
            case Color.ORANGE -> Items.ORANGE_CONCRETE_POWDER;
            case Color.YELLOW -> Items.YELLOW_CONCRETE_POWDER;
            case Color.LIME -> Items.LIME_CONCRETE_POWDER;
            case Color.GREEN -> Items.GREEN_CONCRETE_POWDER;
            case Color.CYAN -> Items.CYAN_CONCRETE_POWDER;
            case Color.LIGHT_BLUE -> Items.LIGHT_BLUE_CONCRETE_POWDER;
            case Color.BLUE -> Items.BLUE_CONCRETE_POWDER;
            case Color.PURPLE -> Items.PURPLE_CONCRETE_POWDER;
            case Color.MAGENTA -> Items.MAGENTA_CONCRETE_POWDER;
            case Color.PINK -> Items.PINK_CONCRETE_POWDER;
            default -> Items.WHITE_CONCRETE_POWDER;
        };
    }

    public static Item GetWoolOfColor(Color color) {
        return switch (color) {
            case Color.LIGHT_GRAY -> Items.LIGHT_GRAY_WOOL;
            case Color.GRAY -> Items.GRAY_WOOL;
            case Color.BLACK -> Items.BLACK_WOOL;
            case Color.BROWN -> Items.BROWN_WOOL;
            case Color.RED -> Items.RED_WOOL;
            case Color.ORANGE -> Items.ORANGE_WOOL;
            case Color.YELLOW -> Items.YELLOW_WOOL;
            case Color.LIME -> Items.LIME_WOOL;
            case Color.GREEN -> Items.GREEN_WOOL;
            case Color.CYAN -> Items.CYAN_WOOL;
            case Color.LIGHT_BLUE -> Items.LIGHT_BLUE_WOOL;
            case Color.BLUE -> Items.BLUE_WOOL;
            case Color.PURPLE -> Items.PURPLE_WOOL;
            case Color.MAGENTA -> Items.MAGENTA_WOOL;
            case Color.PINK -> Items.PINK_WOOL;
            default -> Items.WHITE_WOOL;
        };
    }

    public static ResourceLocation GetWoolTextureOfColor(Color color) {
        return VersionUtil.vanillaResource("block/" + color.getResourceSafeName() + "_wool");
    }

    public static ResourceLocation GetConcreteTextureOfColor(Color color) {
        return VersionUtil.vanillaResource("block/" + color.getResourceSafeName() + "_concrete_powder");
    }
}

