/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.common.crafting.builders;

import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.crafting.MasterTicketRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class MasterTicketRecipeBuilder
implements RecipeBuilder {
    private final Ingredient ingredient;
    private Item result;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    private MasterTicketRecipeBuilder(@Nonnull Ingredient ingredient) {
        this.ingredient = ingredient;
    }

    public static MasterTicketRecipeBuilder of(@Nonnull TagKey<Item> tag) {
        return MasterTicketRecipeBuilder.of(Ingredient.of(tag));
    }

    public static MasterTicketRecipeBuilder of(@Nonnull ItemLike item) {
        return MasterTicketRecipeBuilder.of(Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public static MasterTicketRecipeBuilder of(@Nonnull Ingredient ingredient) {
        return new MasterTicketRecipeBuilder(ingredient);
    }

    @Nonnull
    public MasterTicketRecipeBuilder withResult(@Nonnull Supplier<? extends ItemLike> result) {
        return this.withResult(result.get());
    }

    public MasterTicketRecipeBuilder withResult(@Nonnull ItemLike result) {
        this.result = result.asItem();
        return this;
    }

    @Nonnull
    public MasterTicketRecipeBuilder unlockedBy(@Nonnull String name, @Nonnull Criterion<?> criteria) {
        this.criteria.put(name, criteria);
        return this;
    }

    @Nonnull
    public MasterTicketRecipeBuilder group(@Nullable String group) {
        return this;
    }

    @Nonnull
    public Item getResult() {
        return ModItems.TICKET_MASTER.get();
    }

    public void save(@Nonnull RecipeOutput consumer, @Nonnull ResourceLocation id) {
        this.ensureValid(id);
        Advancement.Builder advancement$builder = consumer.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        consumer.accept(id, (Recipe)new MasterTicketRecipe(this.ingredient, this.result), advancement$builder.build(id.withPrefix("recipes/ticket_machine/")));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
        }
        if (this.ingredient == null) {
            throw new IllegalStateException("No ingredient defined for " + String.valueOf(id));
        }
        if (this.result == null) {
            throw new IllegalStateException("No result defined for " + String.valueOf(id));
        }
    }
}

