/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.client.generators;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class ModelVariantProvider
implements DataProvider {
    protected final String modid;
    private final PackOutput.PathProvider provider;
    private final Map<ResourceLocation, ModelVariant> data = new HashMap<ResourceLocation, ModelVariant>();

    protected ModelVariantProvider(PackOutput output, String modid) {
        this.provider = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "lightmanscurrency/model_variants");
        this.modid = modid;
    }

    protected abstract void addEntries();

    protected final void add(String id, ModelVariant variant) {
        this.add(VersionUtil.modResource(this.modid, id), variant);
    }

    protected final void add(ResourceLocation id, ModelVariant variant) {
        this.data.put(id, variant);
    }

    public CompletableFuture<?> run(CachedOutput output) {
        this.data.clear();
        this.addEntries();
        ArrayList results = new ArrayList();
        this.data.forEach((id, variant) -> {
            JsonObject json = variant.write();
            Path path = this.provider.json(id);
            if (path == null) {
                results.add(CompletableFuture.completedFuture(null));
            } else {
                results.add(DataProvider.saveStable((CachedOutput)output, (JsonElement)json, (Path)path));
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])results.toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "Lightman's Currency Model Variants: " + this.modid;
    }
}

