/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.client.generators;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.custom_models.CustomModelData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class CustomModelDataProvider
implements DataProvider {
    protected final PackOutput output;
    protected final String modid;
    private final PackOutput.PathProvider provider;
    private final Map<ResourceLocation, CustomModelData> data = new HashMap<ResourceLocation, CustomModelData>();

    public CustomModelDataProvider(PackOutput output, String modid) {
        this.output = output;
        this.modid = modid;
        this.provider = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "lightmanscurrency/custom_model_data");
    }

    protected abstract void addEntries();

    public CompletableFuture<?> run(CachedOutput output) {
        this.data.clear();
        this.addEntries();
        ArrayList results = new ArrayList();
        this.data.forEach((id, value) -> {
            JsonObject json = value.write();
            Path path = this.provider.json(id);
            if (path == null) {
                results.add(CompletableFuture.completedFuture(null));
            } else {
                results.add(DataProvider.saveStable((CachedOutput)output, (JsonElement)json, (Path)path));
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])results.toArray(CompletableFuture[]::new));
    }

    protected final void add(String id, CustomModelData data) {
        this.add(VersionUtil.modResource(this.modid, id), data);
    }

    protected final void add(ResourceLocation id, CustomModelData data) {
        this.data.put(id, data);
    }

    public String getName() {
        return "Lightman's Currency Custom Models: " + this.modid;
    }
}

