/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.villager_merchant;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.CustomProfessions;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.CustomVillagerTradeData;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.EnchantedBookForCoinsTrade;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.EnchantedItemForCoinsTrade;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.ItemsForMapTrade;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.RandomTrade;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.SimpleTrade;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.configured.ConfiguredItemListing;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.BasicItemListing;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;

@EventBusSubscriber
public class VillagerTradeManager {
    public static final ResourceLocation BANKER_ID = VersionUtil.lcResource("banker");
    public static final ResourceLocation CASHIER_ID = VersionUtil.lcResource("cashier");
    public static final String WANDERING_TRADER_ID = "minecraft:wandering_trader";
    private static final float ENCHANTMENT_PRICE_MODIFIER = 0.25f;

    public static void registerDefaultTrades() {
        CustomVillagerTradeData.registerDefaultFile(BANKER_ID, (Map<Integer, List<VillagerTrades.ItemListing>>)ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)new SimpleTrade(2, (ItemLike)ModItems.COIN_IRON.get(), 5, (ItemLike)ModBlocks.COIN_MINT.get()), (Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_GOLD.get()), LCTags.Items.NETWORK_TERMINAL, 12, 1, 0.05f), (Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 8), LCTags.Items.ATM, 12, 1, 0.05f), (Object)new SimpleTrade(1, (ItemLike)ModItems.COIN_IRON.get(), 5, (ItemLike)ModBlocks.CASH_REGISTER.get()), (Object)new SimpleTrade(1, (ItemLike)ModItems.COIN_IRON.get(), 4, (ItemLike)ModItems.COIN_COPPER.get(), 8, (ItemLike)ModItems.TRADING_CORE.get())), (Object)2, (Object)ImmutableList.of((Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 6), LCTags.Items.TRADER_SHELF, 12, 5, 0.05f), (Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 14), LCTags.Items.TRADER_SHELF_2x2, 12, 5, 0.05f), (Object)new SimpleTrade(5, (ItemLike)ModItems.COIN_IRON.get(), 15, (ItemLike)ModBlocks.COIN_CHEST.get()), (Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 10), LCTags.Items.TRADER_DISPLAY_CASE, 12, 5, 0.05f)), (Object)3, (Object)ImmutableList.of((Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 15), LCTags.Items.TRADER_CARD_DISPLAY, 12, 10, 0.05f), (Object)new SimpleTrade(10, (ItemLike)ModItems.COIN_IRON.get(), 20, (ItemLike)ModBlocks.ARMOR_DISPLAY.get()), (Object)new SimpleTrade(10, (ItemLike)ModItems.COIN_IRON.get(), 20, (ItemLike)ModBlocks.TICKET_KIOSK.get()), (Object)new SimpleTrade(10, (ItemLike)ModItems.COIN_IRON.get(), 15, (ItemLike)ModBlocks.ITEM_NETWORK_TRADER_1.get()), (Object)new SimpleTrade(10, (ItemLike)ModItems.COIN_IRON.get(), 10, (ItemLike)ModBlocks.TERMINAL.get())), (Object)4, (Object)ImmutableList.of((Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 25), LCTags.Items.TRADER_VENDING_MACHINE, 12, 15, 0.05f), (Object)new SimpleTrade(15, (ItemLike)ModItems.COIN_IRON.get(), 30, (ItemLike)ModBlocks.ITEM_NETWORK_TRADER_2.get()), (Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 30), LCTags.Items.TRADER_FREEZER, 12, 20, 0.05f), (Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 30), LCTags.Items.TRADER_SPECIALTY_BOOKSHELF, 12, 20, 0.05f), (Object)new EnchantedBookForCoinsTrade(ModItems.COIN_DIAMOND.get(), 1, LCTags.Enchantments.MONEY_MENDING, 12, 20, 0.05f)), (Object)5, (Object)ImmutableList.of((Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 25), LCTags.Items.TRADER_LARGE_VENDING_MACHINE, 12, 30, 0.05f), (Object)new SimpleTrade(30, (ItemLike)ModItems.COIN_GOLD.get(), 6, (ItemLike)ModBlocks.ITEM_NETWORK_TRADER_3.get()), (Object)new SimpleTrade(30, (ItemLike)ModItems.COIN_GOLD.get(), 10, (ItemLike)ModBlocks.ITEM_NETWORK_TRADER_4.get()), (Object)new SimpleTrade(30, (ItemLike)ModItems.COIN_GOLD.get(), 10, (ItemLike)ModBlocks.SLOT_MACHINE.get()), (Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 5), LCTags.Items.TRADER_INTERFACE, 12, 30, 0.05f), (Object)new EnchantedBookForCoinsTrade(ModItems.COIN_DIAMOND.get(), 1, LCTags.Enchantments.MONEY_MENDING, 12, 30, 0.05f))));
        CustomVillagerTradeData.registerDefaultFile(CASHIER_ID, (Map<Integer, List<VillagerTrades.ItemListing>>)ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 4), new ItemStack((ItemLike)ModItems.COIN_COPPER.get(), 5), new ItemStack((ItemLike)Items.BREAD, 6), 16, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 7), new ItemStack((ItemLike)Items.COD_BUCKET), 16, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 4), new ItemStack((ItemLike)Items.SHEARS), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 8), new ItemStack((ItemLike)Items.ARROW, 16), 12, 1, 0.05f), (Object)new EnchantedBookForCoinsTrade(1), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 2), new ItemStack((ItemLike)Blocks.BOOKSHELF), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get()), new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 5), new ItemStack((ItemLike)Items.MAP), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get()), new ItemStack((ItemLike)Items.REDSTONE), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 6), new ItemStack((ItemLike)Items.IRON_LEGGINGS), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)Items.IRON_BOOTS), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 3), new ItemStack((ItemLike)Items.IRON_HELMET), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 2), new ItemStack((ItemLike)Items.IRON_CHESTPLATE), 12, 1, 0.05f), (Object[])new VillagerTrades.ItemListing[]{new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 6), new ItemStack((ItemLike)Items.IRON_AXE), 12, 1, 0.05f), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 3, (ItemLike)Items.IRON_SWORD, 12, 1, 0.05f, 0.25), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get()), new ItemStack((ItemLike)Items.STONE_AXE), 12, 1, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get()), new ItemStack((ItemLike)Items.STONE_SHOVEL), 12, 1, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get()), new ItemStack((ItemLike)Items.STONE_PICKAXE), 12, 1, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get()), new ItemStack((ItemLike)Items.STONE_HOE), 12, 1, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Items.RABBIT_STEW), 12, 1, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Items.BRICK, 10), 16, 1, 0.05f)}), (Object)2, (Object)ImmutableList.of((Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)Items.PUMPKIN_PIE, 4), 12, 5, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 6), new ItemStack((ItemLike)Items.APPLE, 4), 16, 5, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 3), new ItemStack((ItemLike)Items.COD, 15), 16, 10, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.CAMPFIRE), 12, 5, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.WHITE_WOOL), 16, 5, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 4), new ItemStack((ItemLike)Items.BOW), 12, 5, 0.05f), (Object)new EnchantedBookForCoinsTrade(5), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.LANTERN), 12, 5, 0.05f), (Object)new ItemsForMapTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 3), (TagKey<Structure>)StructureTags.ON_OCEAN_EXPLORER_MAPS, "filled_map.monument", (Holder<MapDecorationType>)MapDecorationTypes.OCEAN_MONUMENT, 12, 5), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Items.LAPIS_LAZULI), 12, 5, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 4), new ItemStack((ItemLike)Blocks.BELL), 12, 5, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 9), new ItemStack((ItemLike)ModItems.COIN_COPPER.get(), 5), new ItemStack((ItemLike)Items.CHAINMAIL_LEGGINGS), 12, 5, 0.05f), (Object[])new VillagerTrades.ItemListing[]{new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 6), new ItemStack((ItemLike)ModItems.COIN_COPPER.get(), 3), new ItemStack((ItemLike)Items.CHAINMAIL_BOOTS), 12, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 3), new ItemStack((ItemLike)Items.PORKCHOP, 6), 16, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 3), new ItemStack((ItemLike)Items.COOKED_CHICKEN, 8), 16, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.CHISELED_STONE_BRICKS, 4), 16, 5, 0.05f)}), (Object)3, (Object)ImmutableList.of((Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)Items.COOKIE, 18), 18, 10, 0.05f), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 2, (ItemLike)Items.FISHING_ROD, 3, 10, 0.05f, 0.25), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 7), new ItemStack((ItemLike)Items.CROSSBOW), 12, 10, 0.05f), (Object)new EnchantedBookForCoinsTrade(10), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 3), new ItemStack((ItemLike)Blocks.GLASS, 4), 12, 10, 0.05f), (Object)new ItemsForMapTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 4), (TagKey<Structure>)StructureTags.ON_WOODLAND_EXPLORER_MAPS, "filled_map.mansion", (Holder<MapDecorationType>)MapDecorationTypes.WOODLAND_MANSION, 12, 10), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get()), new ItemStack((ItemLike)Blocks.GLOWSTONE), 12, 10, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 7), new ItemStack((ItemLike)ModItems.COIN_COPPER.get(), 4), new ItemStack((ItemLike)Items.CHAINMAIL_HELMET), 12, 10, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 10), new ItemStack((ItemLike)ModItems.COIN_COPPER.get(), 5), new ItemStack((ItemLike)Items.CHAINMAIL_CHESTPLATE), 12, 10, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 6), new ItemStack((ItemLike)Items.SHIELD), 12, 10, 0.05f), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 5, (ItemLike)Items.IRON_AXE, 3, 12, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 4, (ItemLike)Items.IRON_SHOVEL, 3, 12, 0.05f, 0.25), (Object[])new VillagerTrades.ItemListing[]{new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 6, (ItemLike)Items.IRON_PICKAXE, 3, 12, 0.05f, 0.25), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_DIAMOND.get(), 2), new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 1), new ItemStack((ItemLike)Items.DIAMOND_HOE), 3, 10, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.POLISHED_ANDESITE, 4), 16, 10, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.POLISHED_DIORITE, 4), 16, 10, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.POLISHED_GRANITE, 4), 16, 10, 0.05f)}), (Object)4, (Object)ImmutableList.of((Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 2), new ItemStack((ItemLike)Blocks.CAKE), 12, 15, 0.05f), (Object)new SimpleTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), SimpleTrade.createSuspiciousStew((Holder<MobEffect>)MobEffects.NIGHT_VISION, 100), 15), (Object)new SimpleTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), SimpleTrade.createSuspiciousStew((Holder<MobEffect>)MobEffects.JUMP, 160), 15), (Object)new SimpleTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), SimpleTrade.createSuspiciousStew((Holder<MobEffect>)MobEffects.WEAKNESS, 100), 15), (Object)new SimpleTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), SimpleTrade.createSuspiciousStew((Holder<MobEffect>)MobEffects.BLINDNESS, 120), 15), (Object)new SimpleTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), SimpleTrade.createSuspiciousStew((Holder<MobEffect>)MobEffects.POISON, 100), 15), (Object)new SimpleTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), SimpleTrade.createSuspiciousStew((Holder<MobEffect>)MobEffects.SATURATION, 7), 15), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 5, (ItemLike)Items.BOW, 3, 15, 0.05f, 0.25), (Object)new EnchantedBookForCoinsTrade(15), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 5), new ItemStack((ItemLike)Items.CLOCK), 12, 15, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 2), new ItemStack((ItemLike)Items.COMPASS), 12, 15, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get()), new ItemStack((ItemLike)Items.ITEM_FRAME), 12, 15, 0.05f), (Object[])new VillagerTrades.ItemListing[]{new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get()), new ItemStack((ItemLike)Items.ENDER_PEARL), 12, 15, 0.05f), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 7, (ItemLike)Items.DIAMOND_LEGGINGS, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 5, (ItemLike)Items.DIAMOND_BOOTS, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 4, (ItemLike)Items.DIAMOND_AXE, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 3, (ItemLike)Items.DIAMOND_AXE, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 2, (ItemLike)Items.DIAMOND_SHOVEL, 3, 15, 0.05f, 0.25), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.TERRACOTTA, 1), 16, 15, 0.05f)}), (Object)5, (Object)ImmutableList.of((Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 15), new ItemStack((ItemLike)Items.GOLDEN_CARROT), 12, 30, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 2), new ItemStack((ItemLike)Items.GLISTERING_MELON_SLICE), 12, 30, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 5), new ItemStack((ItemLike)Items.PAINTING), 12, 30, 0.05f), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 10, (ItemLike)Items.CROSSBOW, 3, 15, 0.05f, 0.25), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)Items.NAME_TAG), 12, 30, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)Items.GLOBE_BANNER_PATTERN), 12, 30, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), new ItemStack((ItemLike)Blocks.NETHER_WART, 12), 12, 30, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 5), new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE), 12, 30, 0.05f), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 8, (ItemLike)Items.DIAMOND_CHESTPLATE, 3, 30, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 6, (ItemLike)Items.DIAMOND_HELMET, 3, 30, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 4, (ItemLike)Items.DIAMOND_SWORD, 3, 30, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 4, (ItemLike)Items.DIAMOND_PICKAXE, 3, 30, 0.05f, 0.25), (Object[])new VillagerTrades.ItemListing[]{new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)Items.SADDLE), 12, 30, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.QUARTZ_BLOCK), 12, 30, 0.05f)})));
        CustomVillagerTradeData.registerDefaultWanderingTrades((List<VillagerTrades.ItemListing>)ImmutableList.of((Object)new SimpleTrade((ItemLike)ModItems.COIN_GOLD.get(), 1, (ItemLike)ModBlocks.ATM.get()), (Object)new SimpleTrade((ItemLike)ModItems.COIN_IRON.get(), 5, (ItemLike)ModBlocks.CASH_REGISTER.get()), (Object)new SimpleTrade((ItemLike)ModItems.COIN_IRON.get(), 5, (ItemLike)ModBlocks.TERMINAL.get())), (List<VillagerTrades.ItemListing>)ImmutableList.of((Object)RandomTrade.build(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 2), new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 4), LCTags.Items.TRADER_DISPLAY_CASE, 12, 1, 0.05f), (Object)new SimpleTrade((ItemLike)ModItems.COIN_GOLD.get(), 4, (ItemLike)ModBlocks.ARMOR_DISPLAY.get())));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void OnVillagerTradeSetup(VillagerTradesEvent event) {
        if (event.getType() == CustomProfessions.BANKER.get()) {
            if (!((Boolean)LCConfig.COMMON.addBankerVillager.get()).booleanValue()) {
                return;
            }
            LightmansCurrency.LogInfo("Registering banker trades.");
            Map<Integer, List<VillagerTrades.ItemListing>> bankerTrades = CustomVillagerTradeData.getVillagerData(BANKER_ID);
            for (int i = 1; i <= 5; ++i) {
                List currentTrades = (List)event.getTrades().get(i);
                List<VillagerTrades.ItemListing> newTrades = bankerTrades.get(i);
                if (newTrades != null) {
                    currentTrades.addAll(newTrades);
                    continue;
                }
                LightmansCurrency.LogWarning("Banker Trades have no listings for trade level " + i);
            }
        } else if (event.getType() == CustomProfessions.CASHIER.get()) {
            if (!((Boolean)LCConfig.COMMON.addCashierVillager.get()).booleanValue()) {
                return;
            }
            LightmansCurrency.LogInfo("Registering cashier trades.");
            Map<Integer, List<VillagerTrades.ItemListing>> cashierTrades = CustomVillagerTradeData.getVillagerData(CASHIER_ID);
            for (int i = 1; i <= 5; ++i) {
                List currentTrades = (List)event.getTrades().get(i);
                List<VillagerTrades.ItemListing> newTrades = cashierTrades.get(i);
                if (newTrades != null) {
                    currentTrades.addAll(newTrades);
                    continue;
                }
                LightmansCurrency.LogWarning("Cashier Trades have no listings for trade level " + i);
            }
        } else {
            ResourceLocation type = BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)event.getType());
            assert (type != null);
            if (type.getNamespace().equals("minecraft")) {
                if (!((Boolean)LCConfig.COMMON.changeVanillaTrades.get()).booleanValue()) {
                    return;
                }
                LightmansCurrency.LogInfo("Replacing Emeralds for villager type '" + String.valueOf(type) + "'.");
                VillagerTradeManager.replaceExistingTrades(type.toString(), (Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
            } else if (((Boolean)LCConfig.COMMON.changeModdedTrades.get()).booleanValue()) {
                LightmansCurrency.LogInfo("Replacing Emeralds for villager type '" + String.valueOf(type) + "'.");
                VillagerTradeManager.replaceExistingTrades(type.toString(), (Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
            }
        }
    }

    public static void replaceExistingTrades(String trader, Int2ObjectMap<List<VillagerTrades.ItemListing>> trades) {
        trades.forEach((i, list) -> VillagerTradeManager.replaceExistingTrades(trader, list));
    }

    public static void replaceExistingTrades(String trader, List<VillagerTrades.ItemListing> trades) {
        trades.replaceAll(t -> {
            if (t instanceof ConfiguredItemListing) {
                return t;
            }
            return new ConfiguredItemListing((VillagerTrades.ItemListing)t, LCConfig.COMMON.getVillagerMod(trader));
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void OnWandererTradeSetup(WandererTradesEvent event) {
        if (((Boolean)LCConfig.COMMON.changeWanderingTrades.get()).booleanValue()) {
            VillagerTradeManager.replaceExistingTrades(WANDERING_TRADER_ID, event.getGenericTrades());
            VillagerTradeManager.replaceExistingTrades(WANDERING_TRADER_ID, event.getRareTrades());
        }
        if (((Boolean)LCConfig.COMMON.addCustomWanderingTrades.get()).booleanValue()) {
            Pair<List<VillagerTrades.ItemListing>, List<VillagerTrades.ItemListing>> pair = CustomVillagerTradeData.getWanderingTraderData();
            event.getGenericTrades().addAll((Collection)pair.getFirst());
            event.getRareTrades().addAll((Collection)pair.getSecond());
        }
    }
}

