/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.villager_merchant;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.level.ItemLike;

public class ListingUtil {
    @Nonnull
    public static ItemCost costFor(@Nonnull ItemStack stack) {
        if (stack.getComponents().isEmpty()) {
            return new ItemCost((ItemLike)stack.getItem(), stack.getCount());
        }
        Holder holder = BuiltInRegistries.ITEM.wrapAsHolder((Object)stack.getItem());
        int count = stack.getCount();
        return new ItemCost(holder, count, DataComponentPredicate.allOf((DataComponentMap)stack.getComponents()));
    }

    @Nonnull
    public static Optional<ItemCost> optionalCost(@Nonnull ItemStack stack) {
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(ListingUtil.costFor(stack));
    }
}

