/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.gacha;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TradeResult;
import io.github.lightman314.lightmanscurrency.api.traders.TraderType;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.blockentity.handler.GachaItemHandler;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.GachaMachineBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.items.GachaBallItem;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menus.gacha_machine.GachaMachineMenu;
import io.github.lightman314.lightmanscurrency.common.menus.providers.EasyMenuProvider;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.gacha.GachaPriceTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.gacha.GachaStorageTab;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.GachaTradeNotification;
import io.github.lightman314.lightmanscurrency.common.traders.InputTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.GachaStorage;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.tradedata.GachaTradeData;
import io.github.lightman314.lightmanscurrency.common.upgrades.Upgrades;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.CapacityUpgrade;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GachaTrader
extends InputTraderData {
    public static final TraderType<GachaTrader> TYPE = new TraderType<GachaTrader>(VersionUtil.lcResource("gacha"), GachaTrader::new);
    private int color = -1;
    private MoneyValue price = MoneyValue.empty();
    private final GachaItemHandler handler = new GachaItemHandler(this);
    private final GachaStorage storage = new GachaStorage(this::getMaxItems);
    private final List<GachaTradeData> trades = ImmutableList.of((Object)new GachaTradeData(this));

    protected GachaTrader() {
        super(TYPE);
    }

    public GachaTrader(Level level, BlockPos pos, int color) {
        super(TYPE, level, pos);
        this.color = color;
    }

    public int getColor() {
        if (this.color < 0) {
            BlockItem bi;
            Item item = this.getTraderBlock();
            if (item instanceof BlockItem && (item = (bi = (BlockItem)item).getBlock()) instanceof GachaMachineBlock) {
                GachaMachineBlock block = (GachaMachineBlock)item;
                this.color = block.getColor();
            } else {
                this.color = 0xFFFFFF;
            }
            this.markDirty(this::saveColor);
        }
        return this.color;
    }

    public MoneyValue getPrice() {
        return this.price;
    }

    public void setPrice(@Nullable Player player, MoneyValue price) {
        if (this.hasPermission(player, "editTrades")) {
            this.price = price;
            this.markDirty(this::savePrice);
        }
    }

    public GachaStorage getStorage() {
        return this.storage;
    }

    public IItemHandler getItemHandler(Direction side) {
        return this.handler.getHandler(side);
    }

    public void markStorageDirty() {
        this.markDirty(this::saveStorage);
    }

    @Override
    public IconData getIcon() {
        return IconData.of(GachaBallItem.createWithItemAndColor(new ItemStack((ItemLike)ModItems.TRADING_CORE.get()), Color.YELLOW));
    }

    @Override
    protected boolean allowAdditionalUpgradeType(UpgradeType type) {
        return type == Upgrades.ITEM_CAPACITY;
    }

    public int getMaxItems() {
        int limit = 576;
        for (int i = 0; i < this.getUpgrades().getContainerSize(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = this.getUpgrades().getItem(i);
            Item item = stack.getItem();
            if (!(item instanceof UpgradeItem) || !this.allowUpgrade(upgradeItem = (UpgradeItem)item) || upgradeItem.getUpgradeType() != Upgrades.ITEM_CAPACITY) continue;
            limit += UpgradeItem.getUpgradeData(stack).getIntValue(CapacityUpgrade.CAPACITY);
        }
        return limit;
    }

    @Override
    public int getTradeCount() {
        return 1;
    }

    @Override
    public int getTradeStock(int tradeIndex) {
        return this.storage.getItemCount();
    }

    @Override
    protected void saveTrades(CompoundTag compound, HolderLookup.Provider lookup) {
    }

    @Override
    protected MenuProvider getTraderMenuProvider(@Nonnull MenuValidator validator) {
        return new GachaMachineMenuProvider(this.getID(), validator);
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        super.saveAdditional(compound, lookup);
        this.saveStorage(compound, lookup);
        this.savePrice(compound, lookup);
        this.saveColor(compound);
    }

    protected void saveStorage(CompoundTag tag, HolderLookup.Provider lookup) {
        tag.put("Storage", (Tag)this.storage.save(lookup));
    }

    protected void savePrice(CompoundTag tag, HolderLookup.Provider lookup) {
        tag.put("Price", (Tag)this.price.save());
    }

    protected void saveColor(CompoundTag tag) {
        tag.putInt("Color", this.color);
    }

    @Override
    protected void saveAdditionalToJson(JsonObject json, HolderLookup.Provider lookup) {
        json.add("Items", (JsonElement)this.storage.write(lookup));
        json.add("Price", (JsonElement)this.price.toJson());
        json.addProperty("Color", (Number)this.getColor());
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        super.loadAdditional(compound, lookup);
        if (compound.contains("Storage")) {
            this.storage.load(compound.getList("Storage", 10), lookup);
        }
        if (compound.contains("Price")) {
            this.price = MoneyValue.load(compound.getCompound("Price"));
        }
        if (compound.contains("Color")) {
            this.color = compound.getInt("Color");
        }
    }

    @Override
    public IconData inputSettingsTabIcon() {
        return IconData.of((ItemLike)Items.HOPPER);
    }

    @Override
    public MutableComponent inputSettingsTabTooltip() {
        return LCText.TOOLTIP_TRADER_SETTINGS_INPUT_ITEM.get(new Object[0]);
    }

    @Override
    protected void loadAdditionalFromJson(JsonObject json, HolderLookup.Provider lookup) throws JsonSyntaxException, ResourceLocationException {
        this.price = MoneyValue.loadFromJson(GsonHelper.getAsJsonObject((JsonObject)json, (String)"Price"));
        this.storage.read(GsonHelper.getAsJsonArray((JsonObject)json, (String)"Storage"), lookup);
        this.color = GsonHelper.getAsInt((JsonObject)json, (String)"Color", (int)0xFFFFFF);
    }

    @Override
    protected void saveAdditionalPersistentData(CompoundTag compound, HolderLookup.Provider lookup) {
    }

    @Override
    protected void loadAdditionalPersistentData(CompoundTag compound, HolderLookup.Provider lookup) {
    }

    @Override
    protected void getAdditionalContents(List<ItemStack> results) {
        results.addAll(this.storage.getSplitContents());
    }

    @Nonnull
    public List<GachaTradeData> getTradeData() {
        return this.trades;
    }

    @Override
    @Nullable
    public TradeData getTrade(int tradeIndex) {
        return this.trades.getFirst();
    }

    @Override
    public void addTrade(Player requestor) {
    }

    @Override
    public void removeTrade(Player requestor) {
    }

    @Override
    protected TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        if (tradeIndex != 0 || !this.price.isValidPrice()) {
            return TradeResult.FAIL_INVALID_TRADE;
        }
        if (this.storage.isEmpty()) {
            return TradeResult.FAIL_OUT_OF_STOCK;
        }
        GachaTradeData trade = this.trades.getFirst();
        if (this.runPreTradeEvent(trade, context).isCanceled()) {
            return TradeResult.FAIL_TRADE_RULE_DENIAL;
        }
        MoneyValue cost = trade.getCost(context);
        if (!context.hasFunds(cost)) {
            return TradeResult.FAIL_CANNOT_AFFORD;
        }
        ItemStack result = this.storage.findRandomItem(!this.isCreative());
        ItemStack gachaBall = GachaBallItem.createWithItem(result);
        if (!context.canFitItem(gachaBall)) {
            if (!this.isCreative()) {
                this.storage.forceInsertItem(result);
                this.markStorageDirty();
            }
            return TradeResult.FAIL_NO_OUTPUT_SPACE;
        }
        if (!context.getPayment(cost)) {
            return TradeResult.FAIL_CANNOT_AFFORD;
        }
        if (!context.putItem(gachaBall)) {
            context.givePayment(cost);
            if (!this.isCreative()) {
                this.storage.forceInsertItem(result);
                this.markStorageDirty();
            }
            return TradeResult.FAIL_NO_OUTPUT_SPACE;
        }
        MoneyValue taxesPaid = MoneyValue.empty();
        if (this.canStoreMoney()) {
            taxesPaid = this.addStoredMoney(cost, true);
        }
        if (!this.isCreative()) {
            this.markStorageDirty();
        }
        this.pushNotification(GachaTradeNotification.create(result, cost, context.getPlayerReference(), this.getNotificationCategory(), taxesPaid));
        this.runPostTradeEvent(trade, context, this.price, taxesPaid);
        return TradeResult.SUCCESS;
    }

    @Override
    public boolean canMakePersistent() {
        return true;
    }

    @Override
    public void initStorageTabs(ITraderStorageMenu menu) {
        menu.setTab(0, new GachaStorageTab(menu));
        menu.setTab(1, new GachaPriceTab(menu));
    }

    private record GachaMachineMenuProvider(long traderID, MenuValidator validator) implements EasyMenuProvider
    {
        @Nullable
        public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
            return new GachaMachineMenu(containerId, playerInventory, this.traderID, this.validator);
        }
    }
}

