/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.seasonal_events;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.data.types.EventRewardDataCache;
import io.github.lightman314.lightmanscurrency.common.items.ancient_coins.AncientCoinType;
import io.github.lightman314.lightmanscurrency.common.loot.LootManager;
import io.github.lightman314.lightmanscurrency.common.seasonal_events.chocolate.ChocolateEventCoins;
import io.github.lightman314.lightmanscurrency.common.seasonal_events.data.EventData;
import io.github.lightman314.lightmanscurrency.common.seasonal_events.data.EventRange;
import io.github.lightman314.lightmanscurrency.common.util.LookupHelper;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber
public class SeasonalEventManager {
    private static final List<EventData> loadedEvents = new ArrayList<EventData>();
    private static int timer = 0;
    public static final String EVENTS_FILENAME = "config/lightmanscurrency/SeasonalEvents.json";

    @SubscribeEvent(priority=EventPriority.LOWEST)
    private static void onServerStart(ServerStartedEvent event) {
        SeasonalEventManager.reload();
    }

    public static void reload() {
        for (EventData eventData : loadedEvents) {
            LootManager.removeLootModifier(eventData);
        }
        loadedEvents.clear();
        File file = new File(EVENTS_FILENAME);
        if (!file.exists()) {
            loadedEvents.addAll(SeasonalEventManager.getDefaultEvents());
            for (EventData event : loadedEvents) {
                LootManager.addLootModifier(event);
            }
            SeasonalEventManager.saveCurrentEvents();
        } else {
            try {
                JsonObject jsonObject = GsonHelper.parse((String)Files.readString(file.toPath()));
                JsonArray events = GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"Events");
                ArrayList<String> loadedEventIDS = new ArrayList<String>();
                for (int i = 0; i < events.size(); ++i) {
                    try {
                        JsonObject entry = GsonHelper.convertToJsonObject((JsonElement)events.get(i), (String)("Events[" + i + "]"));
                        EventData event = EventData.fromJson(entry, (HolderLookup.Provider)LookupHelper.getRegistryAccess());
                        if (loadedEventIDS.contains(event.eventID)) {
                            throw new JsonSyntaxException("Cannot have two events with the ID of '" + event.eventID + "'!");
                        }
                        loadedEvents.add(event);
                        loadedEventIDS.add(event.eventID);
                        LootManager.addLootModifier(event);
                        continue;
                    }
                    catch (Exception e) {
                        LightmansCurrency.LogWarning("Error loading Seasonal Event #" + i, e);
                    }
                }
            }
            catch (Exception exception) {
                LightmansCurrency.LogWarning("Error loading Seasonal Events", exception);
            }
        }
    }

    private static void saveCurrentEvents() {
        JsonObject json = new JsonObject();
        JsonArray events = new JsonArray();
        for (EventData event : loadedEvents) {
            events.add((JsonElement)event.toJson((HolderLookup.Provider)LookupHelper.getRegistryAccess()));
        }
        json.add("Events", (JsonElement)events);
        try {
            File file = new File(EVENTS_FILENAME);
            FileUtil.writeStringToFile(file, FileUtil.GSON.toJson((JsonElement)json));
        }
        catch (IOException e) {
            LightmansCurrency.LogError("Error writing Seasonal Events to file!", e);
        }
    }

    private static List<EventData> getDefaultEvents() {
        ArrayList<EventData> list = new ArrayList<EventData>();
        list.add(ChocolateEventCoins.lazyEvent(ChocolateEventCoins.CHRISTMAS, "builtin/christmas", (Component)LCText.SEASONAL_EVENT_CHRISTMAS.get(new Object[0])));
        list.add(ChocolateEventCoins.lazyEvent(ChocolateEventCoins.VALENTINES, "builtin/valentines", (Component)LCText.SEASONAL_EVENT_VALENTINES.get(new Object[0])));
        list.add(EventData.builder("builtin/birthday").dateRange(EventRange.create(3, 29, 3, 29)).startingReward(AncientCoinType.randomizingItem(5)).startingRewardMessage((Component)LCText.SEASONAL_EVENT_BIRTHDAY.get(new Object[0])).build());
        return list;
    }

    @SubscribeEvent
    private static void onServerTick(ServerTickEvent.Pre event) {
        if (++timer >= 6000) {
            timer = 0;
            EventRewardDataCache data = EventRewardDataCache.TYPE.get(false);
            if (data == null) {
                LightmansCurrency.LogWarning("Could not get event reward data.");
                return;
            }
            LightmansCurrency.LogDebug("Manually checking for Seasonal Event rewards and clearing inactive events from the reward cache");
            for (ServerPlayer player : event.getServer().getPlayerList().getPlayers()) {
                SeasonalEventManager.checkPlayerRewards(player, data);
            }
            data.clearDisabledEvents(new ArrayList<EventData>(loadedEvents));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            EventRewardDataCache data = EventRewardDataCache.TYPE.get(false);
            if (data != null) {
                SeasonalEventManager.checkPlayerRewards(player2, data);
            }
        }
    }

    private static void checkPlayerRewards(ServerPlayer player, EventRewardDataCache data) {
        if (!((Boolean)LCConfig.COMMON.eventStartingRewards.get()).booleanValue()) {
            return;
        }
        for (EventData event : loadedEvents) {
            if (!event.hasStartingReward() || !event.range.isActive() || !data.shouldGivePlayerReward(player, event.eventID)) continue;
            event.giveStartingReward(player);
            data.playerReceivedReward(player, event.eventID);
        }
    }
}

