/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.playertrading;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.common.menus.PlayerTradeMenu;
import io.github.lightman314.lightmanscurrency.common.playertrading.ClientPlayerTrade;
import io.github.lightman314.lightmanscurrency.common.playertrading.IPlayerTrade;
import io.github.lightman314.lightmanscurrency.network.message.playertrading.SPacketSyncPlayerTrade;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class PlayerTrade
implements IPlayerTrade,
MenuProvider {
    private boolean stillPending = true;
    public final long creationTime;
    public final int tradeID;
    private boolean completed = false;
    private final UUID hostPlayerID;
    private final UUID guestPlayerID;
    private MoneyValue hostMoney = MoneyValue.empty();
    private MoneyValue guestMoney = MoneyValue.empty();
    private final SimpleContainer hostItems = new SimpleContainer(12);
    private final SimpleContainer guestItems = new SimpleContainer(12);
    private int hostState = 0;
    private int guestState = 0;

    public static boolean ignoreDimension() {
        return (Double)LCConfig.SERVER.playerTradingRange.get() < 0.0;
    }

    public static boolean ignoreDistance() {
        return (Double)LCConfig.SERVER.playerTradingRange.get() <= 0.0;
    }

    public static double enforceDistance() {
        return (Double)LCConfig.SERVER.playerTradingRange.get();
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public boolean isHost(@Nonnull Player player) {
        return player.getUUID() == this.hostPlayerID;
    }

    @Override
    public boolean isGuest(@Nonnull Player player) {
        return player.getUUID() == this.guestPlayerID;
    }

    @Override
    @Nonnull
    public UUID getHostID() {
        return this.hostPlayerID;
    }

    @Override
    @Nonnull
    public Component getHostName() {
        ServerPlayer hostPlayer = this.getPlayer(this.hostPlayerID);
        return hostPlayer == null ? Component.literal((String)"NULL") : hostPlayer.getName();
    }

    @Override
    @Nonnull
    public UUID getGuestID() {
        return this.guestPlayerID;
    }

    @Override
    @Nonnull
    public Component getGuestName() {
        ServerPlayer guestPlayer = this.getPlayer(this.guestPlayerID);
        return guestPlayer == null ? Component.literal((String)"NULL") : guestPlayer.getName();
    }

    private boolean playerMissing(@Nonnull UUID playerID) {
        return this.getPlayer(playerID) == null;
    }

    private ServerPlayer getPlayer(UUID playerID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.getPlayerList().getPlayer(playerID);
        }
        return null;
    }

    @Override
    @Nonnull
    public MoneyValue getHostMoney() {
        return this.hostMoney;
    }

    @Override
    @Nonnull
    public MoneyValue getGuestMoney() {
        return this.guestMoney;
    }

    @Override
    @Nonnull
    public Container getHostItems() {
        return this.hostItems;
    }

    @Override
    @Nonnull
    public Container getGuestItems() {
        return this.guestItems;
    }

    @Override
    public int getHostState() {
        return this.hostState;
    }

    @Override
    public int getGuestState() {
        return this.guestState;
    }

    public PlayerTrade(ServerPlayer host, ServerPlayer guest, int tradeID) {
        this.hostPlayerID = host.getUUID();
        this.guestPlayerID = guest.getUUID();
        this.tradeID = tradeID;
        this.creationTime = TimeUtil.getCurrentTime();
        this.hostItems.addListener(this::onContainerChange);
        this.guestItems.addListener(this::onContainerChange);
    }

    private void onContainerChange(Container container) {
        if (this.hostItems == container) {
            this.onTradeEdit(true);
        }
        if (this.guestItems == container) {
            this.onTradeEdit(false);
        }
        this.markDirty();
    }

    private void onTradeEdit(boolean wasHost) {
        if (wasHost) {
            this.guestState = 0;
            this.hostState = Math.min(this.hostState, 1);
        } else {
            this.hostState = 0;
            this.guestState = Math.min(this.guestState, 1);
        }
    }

    private boolean playerDistanceExceeded() {
        return false;
    }

    public int isGuestInRange(ServerPlayer guest) {
        ServerPlayer host = this.getPlayer(this.hostPlayerID);
        if (host == null) {
            return 1;
        }
        if (PlayerTrade.ignoreDimension()) {
            return 0;
        }
        if (!Objects.equals(host.level().dimension().location(), guest.level().dimension().location())) {
            return 3;
        }
        if (PlayerTrade.ignoreDistance()) {
            return 0;
        }
        double distance = host.position().distanceTo(guest.position());
        return distance <= PlayerTrade.enforceDistance() ? 0 : 2;
    }

    private boolean playerAbandonedTrade(boolean host) {
        ServerPlayer player = this.getPlayer(host ? this.hostPlayerID : this.guestPlayerID);
        if (player == null) {
            LightmansCurrency.LogWarning("The " + (host ? "host" : "guest") + " is no longer online. Flagging trade as abandoned.");
            return true;
        }
        if (!this.isInMenu((Player)player)) {
            LightmansCurrency.LogWarning("The " + (host ? "host" : "guest") + " is no longer in the trade menu. Flagging trade as abandoned.");
            return true;
        }
        return false;
    }

    private boolean isInMenu(Player player) {
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.containerMenu) instanceof PlayerTradeMenu) {
            PlayerTradeMenu menu = (PlayerTradeMenu)abstractContainerMenu;
            return menu.tradeID == this.tradeID;
        }
        return false;
    }

    private void takeMenuAction(Consumer<PlayerTradeMenu> action) {
        this.ifInMenu(this.hostPlayerID, action);
        this.ifInMenu(this.guestPlayerID, action);
    }

    private void ifInMenu(UUID playerID, Consumer<PlayerTradeMenu> action) {
        ServerPlayer player = this.getPlayer(playerID);
        if (player != null) {
            this.ifInMenu((Player)player, action);
        }
    }

    private void ifInMenu(Player player, Consumer<PlayerTradeMenu> action) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof PlayerTradeMenu) {
            PlayerTradeMenu menu = (PlayerTradeMenu)abstractContainerMenu;
            if (menu.tradeID == this.tradeID) {
                action.accept(menu);
            }
        }
    }

    public final void tryCloseMenu(UUID playerID) {
        ServerPlayer player = this.getPlayer(playerID);
        if (player != null) {
            this.tryCloseMenu((Player)player);
        }
    }

    public final void tryCloseMenu(Player player) {
        if (this.isInMenu(player)) {
            player.closeContainer();
        }
    }

    public final boolean requestAccepted(ServerPlayer player) {
        if (this.stillPending && this.isGuest((Player)player)) {
            this.stillPending = false;
            ServerPlayer host = this.getPlayer(this.hostPlayerID);
            ServerPlayer guest = this.getPlayer(this.guestPlayerID);
            if (host == null || guest == null) {
                LightmansCurrency.LogWarning("Trade Request accepted, but either the Host or Guest is no longer online.");
                return false;
            }
            host.openMenu((MenuProvider)this, this::writeAdditionalMenuData);
            guest.openMenu((MenuProvider)this, this::writeAdditionalMenuData);
            LightmansCurrency.LogInfo("Trade Request accepted, and Player Trading menu should be open for both players.");
            return true;
        }
        if (!this.stillPending) {
            LightmansCurrency.LogWarning("Trade Request accepted, but the trade is not in a pending state!");
        }
        if (!this.isGuest((Player)player)) {
            LightmansCurrency.LogWarning("Trade Request accepted by the wrong player.");
        }
        return false;
    }

    public boolean shouldCancel() {
        if (this.completed) {
            return true;
        }
        if (this.stillPending) {
            if (this.playerMissing(this.hostPlayerID)) {
                LightmansCurrency.LogInfo("Cancelling pending trade as the host is missing.");
                return true;
            }
            if (this.playerMissing(this.guestPlayerID)) {
                LightmansCurrency.LogInfo("Cancelling pending trade as the guest is missing.");
                return true;
            }
            if (!TimeUtil.compareTime(300000L, this.creationTime)) {
                LightmansCurrency.LogInfo("Cancelling pending trade as the trade has expired.");
                return true;
            }
            return false;
        }
        return this.playerAbandonedTrade(true) || this.playerAbandonedTrade(false) || this.playerDistanceExceeded();
    }

    public void onCancel() {
        if (this.stillPending || this.completed) {
            return;
        }
        this.tryCloseMenu(this.hostPlayerID);
        this.tryCloseMenu(this.guestPlayerID);
    }

    private void tryExecuteTrade() {
        if (this.hostState < 2 || this.guestState < 2 || this.stillPending) {
            return;
        }
        ServerPlayer host = this.getPlayer(this.hostPlayerID);
        ServerPlayer guest = this.getPlayer(this.guestPlayerID);
        if (host == null || guest == null) {
            return;
        }
        IMoneyHolder hostHandler = MoneyAPI.API.GetPlayersMoneyHandler((Player)host);
        IMoneyHolder guestHandler = MoneyAPI.API.GetPlayersMoneyHandler((Player)guest);
        if (hostHandler.extractMoney(this.hostMoney, true).isEmpty() && hostHandler.insertMoney(this.guestMoney, true).isEmpty() && guestHandler.extractMoney(this.guestMoney, true).isEmpty() && guestHandler.insertMoney(this.hostMoney, true).isEmpty()) {
            ItemStack stack;
            int i;
            this.completed = true;
            hostHandler.extractMoney(this.hostMoney, false);
            hostHandler.insertMoney(this.guestMoney, false);
            for (i = 0; i < this.guestItems.getContainerSize(); ++i) {
                stack = this.guestItems.getItem(i);
                if (stack.isEmpty()) continue;
                ItemHandlerHelper.giveItemToPlayer((Player)host, (ItemStack)stack);
            }
            guestHandler.extractMoney(this.guestMoney, false);
            guestHandler.insertMoney(this.hostMoney, false);
            for (i = 0; i < this.hostItems.getContainerSize(); ++i) {
                stack = this.hostItems.getItem(i);
                if (stack.isEmpty()) continue;
                ItemHandlerHelper.giveItemToPlayer((Player)guest, (ItemStack)stack);
            }
            this.tryCloseMenu((Player)host);
            this.tryCloseMenu((Player)guest);
        }
    }

    private ClientPlayerTrade getData() {
        return new ClientPlayerTrade(this.hostPlayerID, this.guestPlayerID, this.getHostName(), this.getGuestName(), this.hostMoney, this.guestMoney, (Container)InventoryUtil.copy((Container)this.hostItems), (Container)InventoryUtil.copy((Container)this.guestItems), this.hostState, this.guestState);
    }

    public void handleInteraction(Player player, CompoundTag message) {
        if (!this.isHost(player) && !this.isGuest(player)) {
            return;
        }
        if (this.isHost(player)) {
            if (message.contains("TogglePropose")) {
                if (this.hostState > 0) {
                    this.hostState = 0;
                    this.guestState = Math.min(this.guestState, 1);
                } else {
                    this.hostState = 1;
                }
            } else if (message.contains("ToggleActive")) {
                if (this.hostState == 2) {
                    this.hostState = 1;
                } else if (this.hostState == 1 && this.guestState > 0) {
                    this.hostState = 2;
                    this.tryExecuteTrade();
                }
            } else if (message.contains("ChangeMoney")) {
                this.hostMoney = MoneyValue.load(message.getCompound("ChangeMoney"));
                this.onTradeEdit(true);
            }
        } else if (this.isGuest(player)) {
            if (message.contains("TogglePropose")) {
                if (this.guestState > 0) {
                    this.guestState = 0;
                    this.hostState = Math.min(this.hostState, 1);
                } else {
                    this.guestState = 1;
                }
            } else if (message.contains("ToggleActive")) {
                if (this.guestState == 2) {
                    this.guestState = 1;
                } else if (this.guestState == 1 && this.hostState > 0) {
                    this.guestState = 2;
                    this.tryExecuteTrade();
                }
            } else if (message.contains("ChangeMoney")) {
                this.guestMoney = MoneyValue.load(message.getCompound("ChangeMoney"));
                this.onTradeEdit(false);
            }
        } else {
            return;
        }
        this.markDirty();
    }

    public final void markDirty() {
        ClientPlayerTrade data = this.getData();
        ServerPlayer hostPlayer = this.getPlayer(this.hostPlayerID);
        ServerPlayer guestPlayer = this.getPlayer(this.guestPlayerID);
        if (hostPlayer != null) {
            new SPacketSyncPlayerTrade(data).sendTo(hostPlayer);
        }
        if (guestPlayer != null) {
            new SPacketSyncPlayerTrade(data).sendTo(guestPlayer);
        }
        this.takeMenuAction(PlayerTradeMenu::onTradeChange);
    }

    @Nonnull
    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowID, @Nonnull Inventory inventory, @Nonnull Player player) {
        return new PlayerTradeMenu(windowID, inventory, this.tradeID, this);
    }

    private void writeAdditionalMenuData(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.tradeID);
        this.getData().encode(buffer);
    }
}

