/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.playertrading;

import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.common.playertrading.IPlayerTrade;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;

public class ClientPlayerTrade
implements IPlayerTrade {
    private final UUID hostID;
    private final UUID guestID;
    private final Component hostName;
    private final Component guestName;
    private final MoneyValue hostMoney;
    private final MoneyValue guestMoney;
    private final Container hostItems;
    private final Container guestItems;
    private final int hostState;
    private final int guestState;

    @Override
    public boolean isCompleted() {
        return false;
    }

    @Override
    @Nonnull
    public UUID getHostID() {
        return this.hostID;
    }

    @Override
    @Nonnull
    public UUID getGuestID() {
        return this.guestID;
    }

    @Override
    @Nonnull
    public Component getHostName() {
        return this.hostName;
    }

    @Override
    @Nonnull
    public Component getGuestName() {
        return this.guestName;
    }

    @Override
    @Nonnull
    public MoneyValue getHostMoney() {
        return this.hostMoney;
    }

    @Override
    @Nonnull
    public MoneyValue getGuestMoney() {
        return this.guestMoney;
    }

    @Override
    @Nonnull
    public Container getHostItems() {
        return this.hostItems;
    }

    @Override
    @Nonnull
    public Container getGuestItems() {
        return this.guestItems;
    }

    @Override
    public int getHostState() {
        return this.hostState;
    }

    @Override
    public int getGuestState() {
        return this.guestState;
    }

    public ClientPlayerTrade(UUID hostID, UUID guestID, Component hostName, Component guestName, MoneyValue hostMoney, MoneyValue guestMoney, Container hostItems, Container guestItems, int hostState, int guestState) {
        this.hostID = hostID;
        this.guestID = guestID;
        this.hostName = hostName;
        this.guestName = guestName;
        this.hostMoney = hostMoney;
        this.guestMoney = guestMoney;
        this.hostItems = hostItems;
        this.guestItems = guestItems;
        this.hostState = hostState;
        this.guestState = guestState;
    }

    public final void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeUUID(this.hostID);
        buffer.writeUUID(this.guestID);
        ComponentSerialization.STREAM_CODEC.encode((Object)buffer, (Object)this.hostName);
        ComponentSerialization.STREAM_CODEC.encode((Object)buffer, (Object)this.guestName);
        this.hostMoney.encode((FriendlyByteBuf)buffer);
        this.guestMoney.encode((FriendlyByteBuf)buffer);
        InventoryUtil.encodeItems(this.hostItems, buffer);
        InventoryUtil.encodeItems(this.guestItems, buffer);
        buffer.writeInt(this.hostState);
        buffer.writeInt(this.guestState);
    }

    public static ClientPlayerTrade decode(RegistryFriendlyByteBuf buffer) {
        UUID hostID = buffer.readUUID();
        UUID guestID = buffer.readUUID();
        Component hostName = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buffer);
        Component guestName = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buffer);
        MoneyValue hostMoney = MoneyValue.decode((FriendlyByteBuf)buffer);
        MoneyValue guestMoney = MoneyValue.decode((FriendlyByteBuf)buffer);
        SimpleContainer hostItems = InventoryUtil.decodeItems(buffer);
        SimpleContainer guestItems = InventoryUtil.decodeItems(buffer);
        int hostState = buffer.readInt();
        int guestState = buffer.readInt();
        return new ClientPlayerTrade(hostID, guestID, hostName, guestName, hostMoney, guestMoney, (Container)hostItems, (Container)guestItems, hostState, guestState);
    }
}

