/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.auction;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.common.notifications.data.ItemData;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseNotification;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class AuctionHouseSellerNobidNotification
extends AuctionHouseNotification {
    public static final NotificationType<AuctionHouseSellerNobidNotification> TYPE = new NotificationType<AuctionHouseSellerNobidNotification>(VersionUtil.lcResource("auction_house_seller_nobid"), AuctionHouseSellerNobidNotification::new);
    List<ItemData> items;

    private AuctionHouseSellerNobidNotification() {
    }

    public AuctionHouseSellerNobidNotification(AuctionTradeData trade) {
        this.items = new ArrayList<ItemData>();
        for (int i = 0; i < trade.getAuctionItems().size(); ++i) {
            this.items.add(new ItemData(trade.getAuctionItems().get(i)));
        }
    }

    @Nonnull
    protected NotificationType<AuctionHouseSellerNobidNotification> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public MutableComponent getMessage() {
        Component itemText = ItemData.getItemNames(this.items);
        return LCText.NOTIFICATION_AUCTION_SELLER_NO_BID.get(itemText);
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        ListTag itemList = new ListTag();
        for (ItemData item : this.items) {
            itemList.add((Object)item.save(lookup));
        }
        compound.put("Items", (Tag)itemList);
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        ListTag itemList = compound.getList("Items", 10);
        this.items = new ArrayList<ItemData>();
        for (int i = 0; i < itemList.size(); ++i) {
            this.items.add(ItemData.load(itemList.getCompound(i), lookup));
        }
    }
}

