/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.auction;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.common.notifications.data.ItemData;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseNotification;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class AuctionHouseBidNotification
extends AuctionHouseNotification {
    public static final NotificationType<AuctionHouseBidNotification> TYPE = new NotificationType<AuctionHouseBidNotification>(VersionUtil.lcResource("auction_house_outbid"), AuctionHouseBidNotification::new);
    List<ItemData> items;
    MoneyValue cost;
    String customer;

    private AuctionHouseBidNotification() {
    }

    public AuctionHouseBidNotification(AuctionTradeData trade) {
        this.cost = trade.getLastBidAmount();
        this.customer = trade.getLastBidPlayer().getName(false);
        this.items = new ArrayList<ItemData>();
        for (int i = 0; i < trade.getAuctionItems().size(); ++i) {
            this.items.add(new ItemData(trade.getAuctionItems().get(i)));
        }
    }

    @Nonnull
    protected NotificationType<AuctionHouseBidNotification> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public MutableComponent getMessage() {
        Component itemText = ItemData.getItemNames(this.items);
        MutableComponent cost = this.cost.getText();
        return LCText.NOTIFICATION_AUCTION_BID.get(this.customer, itemText, cost);
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        ListTag itemList = new ListTag();
        for (ItemData item : this.items) {
            itemList.add((Object)item.save(lookup));
        }
        compound.put("Items", (Tag)itemList);
        compound.put("Price", (Tag)this.cost.save());
        compound.putString("Customer", this.customer);
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        ListTag itemList = compound.getList("Items", 10);
        this.items = new ArrayList<ItemData>();
        for (int i = 0; i < itemList.size(); ++i) {
            this.items.add(ItemData.load(itemList.getCompound(i), lookup));
        }
        this.cost = MoneyValue.safeLoad(compound, "Price");
        this.customer = compound.getString("Customer");
    }
}

