/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.notifications.SingleLineNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TextNotification
extends SingleLineNotification {
    public static final NotificationType<TextNotification> TYPE = new NotificationType<TextNotification>(VersionUtil.lcResource("text"), TextNotification::new);
    private MutableComponent text = EasyText.literal("");
    private NotificationCategory category = NullCategory.INSTANCE;

    private TextNotification() {
    }

    public TextNotification(MutableComponent text) {
        this(text, NullCategory.INSTANCE);
    }

    public TextNotification(MutableComponent text, NotificationCategory category) {
        this.text = text;
        this.category = category;
    }

    public static Supplier<Notification> create(MutableComponent text) {
        return () -> new TextNotification(text);
    }

    public static Supplier<Notification> create(MutableComponent text, NotificationCategory category) {
        return () -> new TextNotification(text, category);
    }

    @Nonnull
    protected NotificationType<TextNotification> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return this.category;
    }

    @Override
    @Nonnull
    public MutableComponent getMessage() {
        return this.text;
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        compound.putString("Text", Component.Serializer.toJson((Component)this.text, (HolderLookup.Provider)lookup));
        compound.put("Category", (Tag)this.category.save(lookup));
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        if (compound.contains("Text", 8)) {
            this.text = Component.Serializer.fromJson((String)compound.getString("Text"), (HolderLookup.Provider)lookup);
        }
        if (compound.contains("Category", 10)) {
            this.category = NotificationAPI.API.LoadCategory(compound.getCompound("Category"), lookup);
        }
    }

    @Override
    protected boolean canMerge(@Nonnull Notification other) {
        if (other instanceof TextNotification) {
            TextNotification otherText = (TextNotification)other;
            return otherText.text.equals((Object)this.text) && otherText.category.matches(this.category);
        }
        return false;
    }
}

