/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.item;

import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.api.upgrades.slot.UpgradeInputSlot;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.item.ItemStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasySlot;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemStorageTab
extends TraderStorageTab {
    List<EasySlot> slots = new ArrayList<EasySlot>();

    public ItemStorageTab(@Nonnull ITraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object screen) {
        return new ItemStorageClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return true;
    }

    public List<? extends Slot> getSlots() {
        return this.slots;
    }

    @Override
    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
        ItemTraderData trader;
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ItemTraderData && !(trader = (ItemTraderData)traderData).isPersistent()) {
            Container upgrades = trader.getUpgrades();
            for (int i = 0; i < upgrades.getContainerSize(); ++i) {
                UpgradeInputSlot upgradeSlot = new UpgradeInputSlot(upgrades, i, 176, 18 + 18 * i, trader);
                upgradeSlot.active = false;
                addSlot.apply(upgradeSlot);
                this.slots.add(upgradeSlot);
            }
        }
    }

    @Override
    public void onTabOpen() {
        EasySlot.SetActive(this.slots);
    }

    @Override
    public void onTabClose() {
        EasySlot.SetInactive(this.slots);
    }

    @Override
    public boolean quickMoveStack(ItemStack stack) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ItemTraderData) {
            ItemTraderData trader = (ItemTraderData)traderData;
            if (trader.isPersistent()) {
                return false;
            }
            TraderItemStorage storage = trader.getStorage();
            if (storage.getFittableAmount(stack) > 0) {
                storage.tryAddItem(stack);
                trader.markStorageDirty();
                return true;
            }
            return trader.quickInsertUpgrade(stack);
        }
        return super.quickMoveStack(stack);
    }

    public void clickedOnSlot(int storageSlot, boolean isShiftHeld, boolean leftClick) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ItemTraderData) {
            ItemTraderData trader = (ItemTraderData)traderData;
            if (trader.isPersistent()) {
                return;
            }
            TraderItemStorage storage = trader.getStorage();
            ItemStack heldItem = ((ITraderStorageMenu)this.menu).getHeldItem();
            if (heldItem.isEmpty()) {
                List<ItemStack> storageContents = storage.getContents();
                if (storageSlot >= 0 && storageSlot < storageContents.size()) {
                    int removedAmount;
                    ItemStack stackToRemove = storageContents.get(storageSlot).copy();
                    ItemStack removeStack = stackToRemove.copy();
                    int tempAmount = Math.min(stackToRemove.getMaxStackSize(), stackToRemove.getCount());
                    stackToRemove.setCount(tempAmount);
                    if (!leftClick) {
                        if (tempAmount > 1) {
                            tempAmount /= 2;
                        }
                        stackToRemove.setCount(tempAmount);
                    }
                    if (isShiftHeld) {
                        ((ITraderStorageMenu)this.menu).getPlayer().getInventory().add(stackToRemove);
                        removedAmount = tempAmount - stackToRemove.getCount();
                    } else {
                        ((ITraderStorageMenu)this.menu).setHeldItem(stackToRemove);
                        removedAmount = tempAmount;
                    }
                    if (removedAmount > 0) {
                        removeStack.setCount(removedAmount);
                        storage.removeItem(removeStack);
                        trader.markStorageDirty();
                    }
                }
            } else if (leftClick) {
                storage.tryAddItem(heldItem);
                trader.markStorageDirty();
            } else {
                ItemStack addItem = heldItem.copy();
                addItem.setCount(1);
                if (storage.addItem(addItem)) {
                    heldItem.shrink(1);
                    if (heldItem.isEmpty()) {
                        ((ITraderStorageMenu)this.menu).setHeldItem(ItemStack.EMPTY);
                    }
                }
                trader.markStorageDirty();
            }
            if (((ITraderStorageMenu)this.menu).isClient()) {
                this.sendStorageClickMessage(storageSlot, isShiftHeld, leftClick);
            }
        }
    }

    private void sendStorageClickMessage(int storageSlot, boolean isShiftHeld, boolean leftClick) {
        ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setInt("ClickedSlot", storageSlot).setBoolean("HeldShift", isShiftHeld).setBoolean("LeftClick", leftClick));
    }

    public void quickTransfer(int type) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ItemTraderData) {
            ItemTraderData trader = (ItemTraderData)traderData;
            if (trader.isPersistent()) {
                return;
            }
            TraderItemStorage storage = trader.getStorage();
            Inventory inv = ((ITraderStorageMenu)this.menu).getPlayer().getInventory();
            boolean changed = false;
            if (type == 0) {
                for (int i = 0; i < 36; ++i) {
                    ItemStack stack = inv.getItem(i);
                    int fillAmount = storage.getFittableAmount(stack);
                    if (fillAmount <= 0) continue;
                    ItemStack fillStack = inv.removeItem(i, fillAmount);
                    storage.forceAddItem(fillStack);
                }
            } else if (type == 1) {
                List<ItemStack> itemList = InventoryUtil.copyList(storage.getContents());
                for (ItemStack stack : itemList) {
                    boolean keepTrying = true;
                    while (storage.getItemCount(stack) > 0 && keepTrying) {
                        ItemStack transferStack = stack.copy();
                        int transferCount = Math.min(storage.getItemCount(stack), stack.getMaxStackSize());
                        transferStack.setCount(transferCount);
                        int removedCount = InventoryUtil.safeGiveToPlayer(inv, transferStack);
                        if (removedCount > 0) {
                            changed = true;
                            ItemStack removeStack = stack.copy();
                            removeStack.setCount(removedCount);
                            storage.removeItem(removeStack);
                            continue;
                        }
                        keepTrying = false;
                    }
                }
            }
            if (changed) {
                trader.markStorageDirty();
            }
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setInt("QuickTransfer", type));
            }
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("ClickedSlot", (byte)2)) {
            int storageSlot = message.getInt("ClickedSlot");
            boolean isShiftHeld = message.getBoolean("HeldShift");
            boolean leftClick = message.getBoolean("LeftClick");
            this.clickedOnSlot(storageSlot, isShiftHeld, leftClick);
        }
        if (message.contains("QuickTransfer")) {
            this.quickTransfer(message.getInt("QuickTransfer"));
        }
    }
}

