/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.core.BasicTradeEditClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BasicTradeEditTab
extends TraderStorageTab
implements IClientTracker {
    public static final int INTERACTION_INPUT = 0;
    public static final int INTERACTION_OUTPUT = 1;
    public static final int INTERACTION_OTHER = 2;
    private final List<Integer> selectedTrades = new ArrayList<Integer>();

    public BasicTradeEditTab(TraderStorageMenu menu) {
        super(menu);
    }

    public int selectedCount() {
        return this.selectedTrades.size();
    }

    public boolean isSelected(@Nonnull TraderData trader, @Nonnull TradeData trade) {
        return ((ITraderStorageMenu)this.menu).hasPermission("editTrades") && this.selectedTrades.contains(trader.indexOfTrade(trade));
    }

    public boolean allTradesSelected() {
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        return trader != null && trader.getTradeCount() == this.selectedTrades.size();
    }

    public boolean allowTradeSelection() {
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        if (trader == null) {
            return false;
        }
        return trader.getTradeCount() > 1 && trader.hasPermission(((ITraderStorageMenu)this.menu).getPlayer(), "editTrades") && trader.supportsMultiPriceEditing();
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object screen) {
        return new BasicTradeEditClientTab<BasicTradeEditTab>(screen, this);
    }

    @Override
    public void onTabClose() {
        this.selectedTrades.clear();
    }

    @Override
    public boolean canOpen(Player player) {
        return true;
    }

    public void sendOpenTabMessage(int newTab, @Nullable LazyPacketData.Builder additionalData) {
        ((ITraderStorageMenu)this.menu).ChangeTab(newTab, additionalData);
    }

    public void SendInputInteractionMessage(int tradeIndex, int interactionIndex, @Nonnull TradeInteractionData data, ItemStack heldItem) {
        ((ITraderStorageMenu)this.menu).SendMessage(data.encode(this.builder().setInt("TradeIndex", tradeIndex).setInt("InteractionType", 0).setInt("InteractionIndex", interactionIndex).setItem("HeldItem", heldItem)));
    }

    public void SendOutputInteractionMessage(int tradeIndex, int interactionIndex, @Nonnull TradeInteractionData data, ItemStack heldItem) {
        ((ITraderStorageMenu)this.menu).SendMessage(data.encode(this.builder().setInt("TradeIndex", tradeIndex).setInt("InteractionType", 1).setInt("InteractionIndex", interactionIndex).setItem("HeldItem", heldItem)));
    }

    public void SendOtherInteractionMessage(int tradeIndex, @Nonnull TradeInteractionData data, @Nonnull ItemStack heldItem) {
        ((ITraderStorageMenu)this.menu).SendMessage(data.encode(this.builder().setInt("TradeIndex", tradeIndex).setInt("InteractionType", 2).setItem("HeldItem", heldItem)));
    }

    public void SelectAllTrades() {
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        if (trader == null) {
            return;
        }
        if (!this.allowTradeSelection()) {
            return;
        }
        int tradeCount = trader.getTradeCount();
        if (this.selectedTrades.size() == tradeCount) {
            this.selectedTrades.clear();
        } else {
            this.selectedTrades.clear();
            for (int i = 0; i < tradeCount; ++i) {
                this.selectedTrades.add(i);
            }
        }
        if (this.isClient()) {
            ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setFlag("SelectAllTrades"));
        }
    }

    public void ToggleTradeSelection(int tradeIndex) {
        if (tradeIndex < 0) {
            return;
        }
        if (!this.allowTradeSelection()) {
            return;
        }
        if (this.selectedTrades.contains(tradeIndex)) {
            this.selectedTrades.remove((Object)tradeIndex);
        } else {
            this.selectedTrades.add(tradeIndex);
        }
        if (this.isClient()) {
            ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setInt("SelectTradeForEdit", tradeIndex));
        }
    }

    public boolean canOpenMultiEdit() {
        return !this.selectedTrades.isEmpty();
    }

    public void OpenMultiEditTab() {
        if (!this.canOpenMultiEdit()) {
            return;
        }
        if (this.isClient()) {
            ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setFlag("OpenMultiEdit"));
        } else {
            ((ITraderStorageMenu)this.menu).ChangeTab(9, this.builder().setList("Selected", this.selectedTrades, LazyPacketData.Builder::setInt));
        }
    }

    public void addTrade() {
        if (((ITraderStorageMenu)this.menu).getTrader() != null) {
            ((ITraderStorageMenu)this.menu).getTrader().addTrade(((ITraderStorageMenu)this.menu).getPlayer());
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setFlag("AddTrade"));
            }
        }
    }

    public void removeTrade() {
        if (((ITraderStorageMenu)this.menu).getTrader() != null) {
            ((ITraderStorageMenu)this.menu).getTrader().removeTrade(((ITraderStorageMenu)this.menu).getPlayer());
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setFlag("RemoveTrade"));
            }
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("TradeIndex", (byte)2)) {
            if (!((ITraderStorageMenu)this.menu).hasPermission("editTrades")) {
                return;
            }
            int tradeIndex = message.getInt("TradeIndex");
            int interaction = message.getInt("InteractionType");
            int interactionIndex = message.getInt("InteractionIndex");
            ItemStack heldItem = message.getItem("HeldItem");
            TradeData trade = ((ITraderStorageMenu)this.menu).getTrader().getTrade(tradeIndex);
            TradeInteractionData data = TradeInteractionData.decode(message);
            switch (interaction) {
                case 0: {
                    trade.OnInputDisplayInteraction(this, interactionIndex, data, heldItem);
                    break;
                }
                case 1: {
                    trade.OnOutputDisplayInteraction(this, interactionIndex, data, heldItem);
                    break;
                }
                case 2: {
                    trade.OnInteraction(this, data, heldItem);
                    break;
                }
                default: {
                    LightmansCurrency.LogWarning("Interaction Type " + interaction + " is not a valid interaction.");
                }
            }
            ((ITraderStorageMenu)this.menu).getTrader().markTradesDirty();
        }
        if (message.contains("AddTrade")) {
            this.addTrade();
        }
        if (message.contains("RemoveTrade")) {
            this.removeTrade();
        }
        if (message.contains("SelectTradeForEdit")) {
            this.ToggleTradeSelection(message.getInt("SelectTradeForEdit"));
        }
        if (message.contains("SelectAllTrades")) {
            this.SelectAllTrades();
        }
        if (message.contains("OpenMultiEdit")) {
            this.OpenMultiEditTab();
        }
    }
}

