/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderinterface.item;

import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettingsState;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.api.trader_interface.menu.TraderInterfaceTab;
import io.github.lightman314.lightmanscurrency.api.upgrades.slot.UpgradeInputSlot;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface.item.ItemStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.blockentity.ItemTraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasySlot;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemStorageTab
extends TraderInterfaceTab {
    List<EasySlot> slots = new ArrayList<EasySlot>();

    public ItemStorageTab(TraderInterfaceMenu menu) {
        super(menu);
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object screen) {
        return new ItemStorageClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return true;
    }

    public List<? extends Slot> getSlots() {
        return this.slots;
    }

    @Override
    public void onTabOpen() {
        EasySlot.SetActive(this.slots);
    }

    @Override
    public void onTabClose() {
        EasySlot.SetInactive(this.slots);
    }

    @Override
    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
        for (int i = 0; i < ((TraderInterfaceMenu)this.menu).getBE().getUpgrades().getContainerSize(); ++i) {
            UpgradeInputSlot upgradeSlot = new UpgradeInputSlot(((TraderInterfaceMenu)this.menu).getBE().getUpgrades(), i, 176, 18 + 18 * i, ((TraderInterfaceMenu)this.menu).getBE(), this::onUpgradeModified);
            upgradeSlot.active = false;
            addSlot.apply(upgradeSlot);
            this.slots.add(upgradeSlot);
        }
    }

    private void onUpgradeModified() {
        ((TraderInterfaceMenu)this.menu).getBE().setUpgradeSlotsDirty();
    }

    @Override
    public boolean quickMoveStack(ItemStack stack) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity = ((TraderInterfaceMenu)this.menu).getBE();
        if (traderInterfaceBlockEntity instanceof ItemTraderInterfaceBlockEntity) {
            ItemTraderInterfaceBlockEntity be = (ItemTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            TraderItemStorage storage = be.getItemBuffer();
            if (storage.getFittableAmount(stack) > 0) {
                storage.tryAddItem(stack);
                be.setItemBufferDirty();
                return true;
            }
            return be.quickInsertUpgrade(stack);
        }
        return super.quickMoveStack(stack);
    }

    public void clickedOnSlot(int storageSlot, boolean isShiftHeld, boolean leftClick) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity;
        if (((TraderInterfaceMenu)this.menu).getBE().canAccess(((TraderInterfaceMenu)this.menu).player) && (traderInterfaceBlockEntity = ((TraderInterfaceMenu)this.menu).getBE()) instanceof ItemTraderInterfaceBlockEntity) {
            ItemTraderInterfaceBlockEntity be = (ItemTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            TraderItemStorage storage = be.getItemBuffer();
            ItemStack heldItem = ((TraderInterfaceMenu)this.menu).getCarried();
            if (heldItem.isEmpty()) {
                List<ItemStack> storageContents = storage.getContents();
                if (storageSlot >= 0 && storageSlot < storageContents.size()) {
                    int removedAmount;
                    ItemStack stackToRemove = storageContents.get(storageSlot).copy();
                    ItemStack removeStack = stackToRemove.copy();
                    int tempAmount = Math.min(stackToRemove.getMaxStackSize(), stackToRemove.getCount());
                    stackToRemove.setCount(tempAmount);
                    if (!leftClick) {
                        if (tempAmount > 1) {
                            tempAmount /= 2;
                        }
                        stackToRemove.setCount(tempAmount);
                    }
                    if (isShiftHeld) {
                        ((TraderInterfaceMenu)this.menu).player.getInventory().add(stackToRemove);
                        removedAmount = tempAmount - stackToRemove.getCount();
                    } else {
                        ((TraderInterfaceMenu)this.menu).setCarried(stackToRemove);
                        removedAmount = tempAmount;
                    }
                    if (removedAmount > 0) {
                        removeStack.setCount(removedAmount);
                        storage.removeItem(removeStack);
                        be.setItemBufferDirty();
                    }
                }
            } else if (leftClick) {
                storage.tryAddItem(heldItem);
                be.setItemBufferDirty();
            } else {
                ItemStack addItem = heldItem.copy();
                addItem.setCount(1);
                if (storage.addItem(addItem)) {
                    heldItem.shrink(1);
                    if (heldItem.isEmpty()) {
                        ((TraderInterfaceMenu)this.menu).setCarried(ItemStack.EMPTY);
                    }
                }
                be.setItemBufferDirty();
            }
            if (((TraderInterfaceMenu)this.menu).isClient()) {
                ((TraderInterfaceMenu)this.menu).SendMessage(this.builder().setInt("ClickedSlot", storageSlot).setBoolean("HeldShift", isShiftHeld).setBoolean("LeftClick", leftClick));
            }
        }
    }

    public void quickTransfer(int type) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity;
        if (((TraderInterfaceMenu)this.menu).getBE().canAccess(((TraderInterfaceMenu)this.menu).player) && (traderInterfaceBlockEntity = ((TraderInterfaceMenu)this.menu).getBE()) instanceof ItemTraderInterfaceBlockEntity) {
            ItemTraderInterfaceBlockEntity be = (ItemTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            TraderItemStorage storage = be.getItemBuffer();
            Inventory inv = ((TraderInterfaceMenu)this.menu).player.getInventory();
            boolean changed = false;
            if (type == 0) {
                for (int i = 0; i < 36; ++i) {
                    ItemStack stack = inv.getItem(i);
                    int fillAmount = storage.getFittableAmount(stack);
                    if (fillAmount <= 0) continue;
                    ItemStack fillStack = inv.removeItem(i, fillAmount);
                    storage.forceAddItem(fillStack);
                }
            } else if (type == 1) {
                List<ItemStack> itemList = InventoryUtil.copyList(storage.getContents());
                for (ItemStack stack : itemList) {
                    boolean keepTrying = true;
                    while (storage.getItemCount(stack) > 0 && keepTrying) {
                        ItemStack transferStack = stack.copy();
                        int transferCount = Math.min(storage.getItemCount(stack), stack.getMaxStackSize());
                        transferStack.setCount(transferCount);
                        int removedCount = InventoryUtil.safeGiveToPlayer(inv, transferStack);
                        if (removedCount > 0) {
                            changed = true;
                            ItemStack removeStack = stack.copy();
                            removeStack.setCount(removedCount);
                            storage.removeItem(removeStack);
                            continue;
                        }
                        keepTrying = false;
                    }
                }
            }
            if (changed) {
                be.setItemBufferDirty();
            }
            if (((TraderInterfaceMenu)this.menu).isClient()) {
                ((TraderInterfaceMenu)this.menu).SendMessage(this.builder().setInt("QuickTransfer", type));
            }
        }
    }

    public void toggleSide(Direction side, DirectionalSettingsState state) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity;
        if (((TraderInterfaceMenu)this.menu).getBE().canAccess(((TraderInterfaceMenu)this.menu).player) && (traderInterfaceBlockEntity = ((TraderInterfaceMenu)this.menu).getBE()) instanceof ItemTraderInterfaceBlockEntity) {
            ItemTraderInterfaceBlockEntity be = (ItemTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            be.getItemHandler().toggleSide(side, state);
            be.setHandlerDirty(be.getItemHandler());
        }
    }

    @Override
    public void handleMessage(@Nonnull LazyPacketData message) {
        if (message.contains("ClickedSlot")) {
            int storageSlot = message.getInt("ClickedSlot");
            boolean isShiftHeld = message.getBoolean("HeldShift");
            boolean leftClick = message.getBoolean("LeftClick");
            this.clickedOnSlot(storageSlot, isShiftHeld, leftClick);
        }
        if (message.contains("QuickTransfer")) {
            this.quickTransfer(message.getInt("QuickTransfer"));
        }
    }
}

