/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.teams.tabs;

import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamSalarySettingsClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.TeamManagementMenu;
import io.github.lightman314.lightmanscurrency.common.menus.teams.TeamManagementTab;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import javax.annotation.Nonnull;

public class TeamSalarySettingsTab
extends TeamManagementTab.BankManagement {
    public TeamSalarySettingsTab(@Nonnull TeamManagementMenu menu) {
        super(menu);
    }

    @Override
    @Nonnull
    protected TeamManagementTab.Management.AccessLevel accessLevel() {
        return TeamManagementTab.Management.AccessLevel.ADMINS;
    }

    @Override
    @Nonnull
    public Object createClientTab(@Nonnull Object screen) {
        return new TeamSalarySettingsClientTab(screen, this);
    }

    public void SetAutoSalary(boolean enabled) {
        if (((TeamManagementMenu)this.menu).isClient()) {
            ((TeamManagementMenu)this.menu).SendMessage(this.builder().setBoolean("EnableAutoSalary", enabled));
        } else {
            ITeam iTeam = ((TeamManagementMenu)this.menu).selectedTeam();
            if (iTeam instanceof Team) {
                Team team = (Team)iTeam;
                team.setAutoSalaryEnabled(((TeamManagementMenu)this.menu).player, enabled);
            }
        }
    }

    public void SetSalaryNotification(boolean enabled) {
        if (((TeamManagementMenu)this.menu).isClient()) {
            ((TeamManagementMenu)this.menu).SendMessage(this.builder().setBoolean("SalaryNotification", enabled));
        } else {
            ITeam iTeam = ((TeamManagementMenu)this.menu).selectedTeam();
            if (iTeam instanceof Team) {
                Team team = (Team)iTeam;
                team.setSalaryNotification(((TeamManagementMenu)this.menu).player, enabled);
            }
        }
    }

    public void SetSalaryDelay(long delay) {
        if (((TeamManagementMenu)this.menu).isClient()) {
            ((TeamManagementMenu)this.menu).SendMessage(this.builder().setLong("SalaryDelay", delay));
        } else {
            ITeam iTeam = ((TeamManagementMenu)this.menu).selectedTeam();
            if (iTeam instanceof Team) {
                Team team = (Team)iTeam;
                team.setSalaryDelay(((TeamManagementMenu)this.menu).player, delay);
            }
        }
    }

    public void SetSalaryLoginRequirement(boolean loginRequired) {
        if (((TeamManagementMenu)this.menu).isClient()) {
            ((TeamManagementMenu)this.menu).SendMessage(this.builder().setBoolean("LoginRequirement", loginRequired));
        } else {
            ITeam iTeam = ((TeamManagementMenu)this.menu).selectedTeam();
            if (iTeam instanceof Team) {
                Team team = (Team)iTeam;
                team.setLoginRequiredForSalary(((TeamManagementMenu)this.menu).player, loginRequired);
            }
        }
    }

    public void ManuallyTriggerSalary() {
        if (((TeamManagementMenu)this.menu).isClient()) {
            ((TeamManagementMenu)this.menu).SendMessage(this.builder().setFlag("TriggerSalary"));
        } else {
            ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
            if (team == null || !team.isAdmin(((TeamManagementMenu)this.menu).player)) {
                return;
            }
            team.forcePaySalaries(false);
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("EnableAutoSalary")) {
            this.SetAutoSalary(message.getBoolean("EnableAutoSalary"));
        }
        if (message.contains("SalaryNotification")) {
            this.SetSalaryNotification(message.getBoolean("SalaryNotification"));
        }
        if (message.contains("SalaryDelay")) {
            this.SetSalaryDelay(message.getLong("SalaryDelay"));
        }
        if (message.contains("LoginRequirement")) {
            this.SetSalaryLoginRequirement(message.getBoolean("LoginRequirement"));
        }
        if (message.contains("TriggerSalary")) {
            this.ManuallyTriggerSalary();
        }
    }
}

