/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.tabbed;

import com.google.common.collect.ImmutableMap;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.client.gui.easy.tabbed.IEasyTabbedMenuScreen;
import io.github.lightman314.lightmanscurrency.common.menus.LazyMessageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.tabbed.EasyMenuTab;
import io.github.lightman314.lightmanscurrency.common.menus.tabbed.IEasyTabbedMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.util.DebugUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;

public abstract class EasyTabbedMenu<M extends IEasyTabbedMenu<T>, T extends EasyMenuTab<M, T>>
extends LazyMessageMenu
implements IEasyTabbedMenu<T> {
    private boolean tabsLocked = false;
    private int currentTabIndex = -1;
    private int currentAddIndex = 0;
    private Map<Integer, T> menuTabs = null;
    private IEasyTabbedMenuScreen<M, T, ?> screen = null;
    private Consumer<LazyPacketData> messageListener = null;

    @Nonnull
    public final T currentTab() {
        return (T)((EasyMenuTab)this.menuTabs.get(this.currentTabIndex));
    }

    @Override
    @Nonnull
    public final Map<Integer, T> getAllTabs() {
        return this.menuTabs == null ? ImmutableMap.of() : ImmutableMap.copyOf(this.menuTabs);
    }

    public void setScreen(@Nonnull IEasyTabbedMenuScreen<M, T, ?> screen) {
        this.screen = screen;
    }

    public EasyTabbedMenu(@Nonnull MenuType<?> type, int id, @Nonnull Inventory inventory, @Nonnull MenuValidator validator) {
        super(type, id, inventory, validator);
    }

    public EasyTabbedMenu(@Nonnull MenuType<?> type, int id, @Nonnull Inventory inventory) {
        super(type, id, inventory);
    }

    @Override
    public final void setMessageListener(@Nonnull Consumer<LazyPacketData> listener) {
        this.messageListener = listener;
    }

    protected final void initializeTabs() {
        if (this.tabsLocked) {
            throw new IllegalStateException("Cannot initialize the menus tabs when they've already be initialized!");
        }
        this.menuTabs = new HashMap<Integer, T>();
        this.registerTabs();
        if (!this.menuTabs.containsKey(0)) {
            throw new IllegalArgumentException("EasyTabbedMenu#registerTabs did not register a tab for key 0!");
        }
        this.tabsLocked = true;
        for (EasyMenuTab tab : this.menuTabs.values()) {
            tab.addStorageMenuSlots(x$0 -> this.addSlot((Slot)x$0));
        }
        this.ChangeTab(0, null, false);
    }

    protected abstract void registerTabs();

    public final void addTab(@Nonnull T tab) {
        if (this.tabsLocked || this.menuTabs == null) {
            this.setTab(this.currentAddIndex, tab);
        } else {
            this.setTab(this.currentAddIndex++, tab);
        }
    }

    public final void setTab(int key, @Nonnull T tab) {
        if (this.tabsLocked) {
            LightmansCurrency.LogError("Attempted to define a tab for the menu after the registration has been locked!");
            return;
        }
        if (this.menuTabs == null) {
            LightmansCurrency.LogError("Attempted to register a tab for the menu outside of the #registerTabs function!");
            return;
        }
        this.menuTabs.put(key, tab);
    }

    public final void clearTab(int key) {
        if (this.tabsLocked) {
            LightmansCurrency.LogError("Attempted to clear a tab for the menu after the registration has been locked!");
            return;
        }
        if (this.menuTabs == null) {
            LightmansCurrency.LogError("Attempted to clear a tab for the menu outside of the #registerTabs function!");
            return;
        }
        if (key == 0) {
            LightmansCurrency.LogError("Attempted to clear the tab for the root key!");
            return;
        }
        this.menuTabs.remove(key);
    }

    @Override
    public final void ChangeTab(int newTab) {
        this.ChangeTab(newTab, null, true);
    }

    @Override
    public final void ChangeTab(int newTab, @Nullable LazyPacketData.Builder data) {
        this.ChangeTab(newTab, data == null ? null : data.build());
    }

    @Override
    public final void ChangeTab(int newTab, @Nullable LazyPacketData data) {
        this.ChangeTab(newTab, data, true);
    }

    private void ChangeTab(int newTab, @Nullable LazyPacketData data, boolean sendPacket) {
        if (newTab == this.currentTabIndex) {
            return;
        }
        if (!this.menuTabs.containsKey(newTab)) {
            LightmansCurrency.LogError("Attempted to open tab " + newTab + ", but no tab with that key is present in the menu!");
            return;
        }
        if (this.currentTab() != null) {
            ((EasyMenuTab)this.currentTab()).onTabClose();
        }
        this.currentTabIndex = newTab;
        if (data != null && data.size("ChangeTab") > 0) {
            ((EasyMenuTab)this.currentTab()).OpenMessage(data);
        }
        ((EasyMenuTab)this.currentTab()).onTabOpen();
        this.onTabChanged(this.currentTab());
        if (sendPacket) {
            LazyPacketData.Builder builder = data != null ? data.copyToBuilder() : this.builder();
            builder.setInt("ChangeTab", newTab);
            LightmansCurrency.LogDebug("Sending Change Tab message from the " + DebugUtil.getSideText(this) + "\n" + String.valueOf(builder));
            this.SendMessage(builder);
        }
        if (this.screen != null && this.screen.getCurrentTabIndex() != this.currentTabIndex) {
            this.screen.ChangeTab(this.currentTabIndex, data, false);
        }
    }

    protected void onTabChanged(T newTab) {
    }

    @Override
    public final void HandleMessage(@Nonnull LazyPacketData message) {
        if (message.contains("ChangeTab")) {
            LightmansCurrency.LogDebug("Handling Change Tab message on the " + DebugUtil.getSideText(this) + "\n" + String.valueOf(message));
            this.ChangeTab(message.getInt("ChangeTab"), message, false);
        }
        ((EasyMenuTab)this.currentTab()).receiveMessage(message);
        this.HandleMessages(message);
        if (this.messageListener != null) {
            this.messageListener.accept(message);
        }
    }

    protected void HandleMessages(@Nonnull LazyPacketData message) {
    }

    public void removed(@Nonnull Player player) {
        super.removed(player);
        for (EasyMenuTab tab : this.menuTabs.values()) {
            tab.onMenuClose();
        }
    }
}

