/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.slots;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class WalletSlot
extends Slot {
    public static final ResourceLocation EMPTY_WALLET_SLOT = VersionUtil.lcResource("item/empty_wallet_slot");
    public static final Pair<ResourceLocation, ResourceLocation> BACKGROUND = Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_WALLET_SLOT);

    public WalletSlot(Player player, Container inventory, int index, int x, int y) {
        super(inventory, index, x, y);
    }

    public boolean mayPlace(@Nonnull ItemStack stack) {
        return WalletSlot.isValidWallet(stack);
    }

    public static boolean isValidWallet(ItemStack stack) {
        return stack.isEmpty() || stack.getItem() instanceof WalletItem;
    }

    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return BACKGROUND;
    }
}

