/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.containers;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SuppliedItemContainer
implements Container {
    private final Supplier<IItemInteractable> supplier;

    public SuppliedItemContainer(@Nonnull Supplier<IItemInteractable> supplier) {
        this.supplier = supplier;
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.getItem(0).isEmpty();
    }

    @Nonnull
    public ItemStack getItem(int slot) {
        if (slot != 0) {
            return ItemStack.EMPTY;
        }
        IItemInteractable interactable = this.supplier.get();
        if (interactable == null) {
            return ItemStack.EMPTY;
        }
        return interactable.getItem();
    }

    @Nonnull
    public ItemStack removeItem(int slot, int count) {
        if (slot != 0) {
            return ItemStack.EMPTY;
        }
        IItemInteractable interactable = this.supplier.get();
        if (interactable == null) {
            return ItemStack.EMPTY;
        }
        return interactable.getItem().split(count);
    }

    @Nonnull
    public ItemStack removeItemNoUpdate(int slot) {
        if (slot != 0) {
            return ItemStack.EMPTY;
        }
        IItemInteractable interactable = this.supplier.get();
        if (interactable == null) {
            return ItemStack.EMPTY;
        }
        ItemStack result = interactable.getItem();
        interactable.setItem(ItemStack.EMPTY);
        return result;
    }

    public void setItem(int slot, @Nonnull ItemStack stack) {
        if (slot != 0) {
            return;
        }
        IItemInteractable interactable = this.supplier.get();
        if (interactable == null) {
            return;
        }
        interactable.setItem(stack);
    }

    public void setChanged() {
    }

    public boolean stillValid(@Nonnull Player player) {
        return true;
    }

    public void clearContent() {
    }

    public static interface IItemInteractable {
        @Nonnull
        public ItemStack getItem();

        public void setItem(@Nonnull ItemStack var1);
    }
}

