/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.containers;

import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SuppliedContainer
implements Container {
    public final Supplier<Container> source;
    private final Container nullContainer;

    public SuppliedContainer(Supplier<Container> source) {
        this(source, (Container)new SimpleContainer(1));
    }

    public SuppliedContainer(Supplier<Container> source, Container nullContainer) {
        this.source = source;
        this.nullContainer = nullContainer;
    }

    private Container safeGet() {
        Container c = this.source.get();
        return c == null ? this.nullContainer : c;
    }

    private boolean validSlot(int slot) {
        Container c = this.safeGet();
        return slot >= 0 && slot < c.getContainerSize();
    }

    public void clearContent() {
        this.safeGet().clearContent();
    }

    public int getContainerSize() {
        return this.safeGet().getContainerSize();
    }

    public boolean isEmpty() {
        return this.safeGet().isEmpty();
    }

    @Nonnull
    public ItemStack getItem(int slot) {
        if (this.validSlot(slot)) {
            return this.safeGet().getItem(slot);
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public ItemStack removeItem(int slot, int count) {
        if (this.validSlot(slot)) {
            return this.safeGet().removeItem(slot, count);
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public ItemStack removeItemNoUpdate(int slot) {
        if (this.validSlot(slot)) {
            return this.safeGet().removeItemNoUpdate(slot);
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int slot, @Nonnull ItemStack stack) {
        if (this.validSlot(slot)) {
            this.safeGet().setItem(slot, stack);
        }
    }

    public int getMaxStackSize() {
        return this.safeGet().getMaxStackSize();
    }

    public void setChanged() {
        this.safeGet().setChanged();
    }

    public boolean stillValid(@Nonnull Player player) {
        return this.safeGet().stillValid(player);
    }

    public void startOpen(@Nonnull Player player) {
        this.safeGet().startOpen(player);
    }

    public void stopOpen(@Nonnull Player player) {
        this.safeGet().stopOpen(player);
    }

    public boolean canPlaceItem(int slot, @Nonnull ItemStack stack) {
        return this.safeGet().canPlaceItem(slot, stack) && this.validSlot(slot);
    }

    public int countItem(@Nonnull Item item) {
        return this.safeGet().countItem(item);
    }

    public boolean hasAnyOf(@Nonnull Set<Item> items) {
        return this.safeGet().hasAnyOf(items);
    }
}

