/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.containers;

import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class NonEmptyContainer
implements Container {
    private List<ItemStack> items;

    public NonEmptyContainer(@Nonnull List<ItemStack> items) {
        this.items = NonEmptyContainer.clean(items);
    }

    public NonEmptyContainer(@Nonnull Container other) {
        this((List<ItemStack>)InventoryUtil.buildList(other));
    }

    public void save(@Nonnull CompoundTag tag, @Nonnull String key, @Nonnull HolderLookup.Provider lookup) {
        InventoryUtil.saveAllItems(key, tag, this, lookup);
    }

    public static NonEmptyContainer load(@Nonnull CompoundTag tag, @Nonnull String key, @Nonnull HolderLookup.Provider lookup) {
        return new NonEmptyContainer((Container)InventoryUtil.loadAllItems(key, tag, tag.getList(key, 10).size(), lookup));
    }

    private static List<ItemStack> clean(@Nonnull List<ItemStack> list) {
        return new ArrayList<ItemStack>(list.stream().filter(s -> !s.isEmpty()).toList());
    }

    private void checkContents() {
        this.items = NonEmptyContainer.clean(this.items);
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty() || this.items.stream().allMatch(ItemStack::isEmpty);
    }

    private boolean validSlot(int slot) {
        return slot >= 0 && slot < this.items.size();
    }

    @Nonnull
    public ItemStack getItem(int slot) {
        if (!this.validSlot(slot)) {
            return ItemStack.EMPTY;
        }
        return this.items.get(slot);
    }

    @Nonnull
    public ItemStack removeItem(int slot, int count) {
        ItemStack item = this.getItem(slot);
        ItemStack result = item.split(count);
        if (item.isEmpty() && this.validSlot(slot)) {
            this.items.remove(slot);
        }
        return result;
    }

    @Nonnull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack item = this.getItem(slot);
        if (this.validSlot(slot)) {
            this.items.remove(slot);
        }
        return item;
    }

    public void setItem(int slot, @Nonnull ItemStack item) {
        if (this.validSlot(slot)) {
            this.items.set(slot, item);
        } else {
            this.items.add(item);
        }
    }

    public void setChanged() {
        this.checkContents();
    }

    public boolean stillValid(@Nonnull Player player) {
        return true;
    }

    public void clearContent() {
        this.items = new ArrayList<ItemStack>();
    }
}

