/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.loot.functions;

import com.mojang.serialization.MapCodec;
import io.github.lightman314.lightmanscurrency.common.blockentity.variant.IVariantSupportingBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.core.ModLootFunctionTypes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ModelVariantLootFunction
implements LootItemFunction {
    public static final ModelVariantLootFunction INSTANCE = new ModelVariantLootFunction();
    public static final MapCodec<ModelVariantLootFunction> CODEC = MapCodec.unit((Object)INSTANCE);

    private ModelVariantLootFunction() {
    }

    public LootItemFunctionType<? extends LootItemFunction> getType() {
        return ModLootFunctionTypes.MODEL_VARIANT.get();
    }

    public ItemStack apply(ItemStack stack, LootContext lootContext) {
        IVariantSupportingBlockEntity be;
        ResourceLocation variantID;
        ServerLevel level = lootContext.getLevel();
        Object object = lootContext.getParam(LootContextParams.BLOCK_ENTITY);
        if (object instanceof IVariantSupportingBlockEntity && (variantID = (be = (IVariantSupportingBlockEntity)object).getCurrentVariant()) != null) {
            stack.set(ModDataComponents.MODEL_VARIANT, (Object)variantID);
        }
        return stack;
    }

    public static LootItemFunction.Builder builder() {
        return () -> INSTANCE;
    }
}

