/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.items.data.TicketData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class TicketItem
extends Item {
    public TicketItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        long ticketID;
        if (TicketItem.isPass(stack)) {
            tooltip.add((Component)LCText.TOOLTIP_PASS.get(new Object[0]));
        }
        if ((ticketID = TicketItem.GetTicketID(stack)) >= -2L) {
            tooltip.add((Component)LCText.TOOLTIP_TICKET_ID.get(ticketID));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public void inventoryTick(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull Entity entity, int slot, boolean selected) {
        TicketItem.GetTicketID(stack);
    }

    public static boolean isTicket(ItemStack ticket) {
        if (ticket.isEmpty() || !ticket.has(ModDataComponents.TICKET_DATA)) {
            return false;
        }
        return ticket.getItem() instanceof TicketItem && InventoryUtil.ItemHasTag(ticket, LCTags.Items.TICKETS_TICKET);
    }

    public static boolean isPass(ItemStack ticket) {
        if (ticket.isEmpty() || !ticket.has(ModDataComponents.TICKET_DATA)) {
            return false;
        }
        return ticket.getItem() instanceof TicketItem && InventoryUtil.ItemHasTag(ticket, LCTags.Items.TICKETS_PASS);
    }

    public static boolean isTicketOrPass(ItemStack ticket) {
        return TicketItem.isTicket(ticket) || TicketItem.isPass(ticket);
    }

    public static boolean isMasterTicket(ItemStack ticket) {
        if (ticket.isEmpty() || !ticket.has(ModDataComponents.TICKET_DATA)) {
            return false;
        }
        return ticket.getItem() instanceof TicketItem && InventoryUtil.ItemHasTag(ticket, LCTags.Items.TICKETS_MASTER);
    }

    public static long GetTicketID(ItemStack ticket) {
        if (ticket.isEmpty() || !(ticket.getItem() instanceof TicketItem) || !ticket.has(ModDataComponents.TICKET_DATA)) {
            return Long.MIN_VALUE;
        }
        return ((TicketData)ticket.get(ModDataComponents.TICKET_DATA)).id();
    }

    public static int GetTicketColor(ItemStack ticket) {
        if (ticket.isEmpty() || !(ticket.getItem() instanceof TicketItem) || !ticket.has(ModDataComponents.TICKET_DATA)) {
            return 0xFFFFFF;
        }
        return ((TicketData)ticket.get(ModDataComponents.TICKET_DATA)).color();
    }

    public static int GetDefaultTicketColor(long ticketID) {
        if (ticketID == -1L) {
            return Color.YELLOW.hexColor;
        }
        if (ticketID == -2L) {
            return Color.BLUE.hexColor;
        }
        return Color.getFromIndex((long)ticketID).hexColor;
    }

    public static ItemStack CraftTicket(@Nonnull ItemStack master, @Nonnull Item item) {
        if (TicketItem.isMasterTicket(master)) {
            return TicketItem.CreateTicket(item, TicketItem.GetTicketID(master), TicketItem.GetTicketColor(master));
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack CreateTicket(Item item, long ticketID) {
        return TicketItem.CreateTicket(item, ticketID, TicketItem.GetDefaultTicketColor(ticketID));
    }

    public static ItemStack CreateTicket(Item item, long ticketID, int color) {
        return TicketItem.CreateTicket(item, ticketID, color, 1);
    }

    public static ItemStack CreateTicket(Item item, long ticketID, int color, int count) {
        ItemStack ticket = new ItemStack((ItemLike)item, count);
        ticket.set(ModDataComponents.TICKET_DATA, (Object)new TicketData(ticketID, color));
        return ticket;
    }

    public static ItemStack CreateExampleTicket(@Nonnull Item item, @Nonnull Color color) {
        ItemStack ticket = new ItemStack((ItemLike)item);
        ticket.set(ModDataComponents.TICKET_DATA, (Object)new TicketData(Long.MIN_VALUE, color.hexColor));
        return ticket;
    }

    public static void SetTicketColor(ItemStack ticket, Color color) {
        TicketItem.SetTicketColor(ticket, color.hexColor);
    }

    public static void SetTicketColor(ItemStack ticket, int color) {
        if (!ticket.has(ModDataComponents.TICKET_DATA)) {
            return;
        }
        TicketData oldData = (TicketData)ticket.get(ModDataComponents.TICKET_DATA);
        ticket.set(ModDataComponents.TICKET_DATA, (Object)new TicketData(oldData.id(), color));
    }
}

