/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.impl;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.taxes.ITaxCollector;
import io.github.lightman314.lightmanscurrency.api.taxes.ITaxable;
import io.github.lightman314.lightmanscurrency.api.taxes.TaxAPI;
import io.github.lightman314.lightmanscurrency.api.taxes.reference.TaxReferenceType;
import io.github.lightman314.lightmanscurrency.common.data.types.TaxDataCache;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class TaxAPIImpl
extends TaxAPI {
    public static final TaxAPI INSTANCE = new TaxAPIImpl();
    private final Map<ResourceLocation, TaxReferenceType> referenceTypes = new HashMap<ResourceLocation, TaxReferenceType>();

    private TaxAPIImpl() {
    }

    @Override
    public void RegisterReferenceType(@Nonnull TaxReferenceType type) {
        ResourceLocation id = type.typeID;
        if (this.referenceTypes.containsKey(id)) {
            LightmansCurrency.LogWarning("Attempted to register the TaxReferenceType '" + String.valueOf(id) + "' twice!");
        } else {
            this.referenceTypes.put(id, type);
            LightmansCurrency.LogDebug("Registered TaxReferenceType '" + String.valueOf(id) + "'!");
        }
    }

    @Override
    @Nullable
    public TaxReferenceType GetReferenceType(@Nonnull ResourceLocation type) {
        return this.referenceTypes.get(type);
    }

    @Override
    @Nonnull
    public List<ITaxCollector> GetTaxCollectorsFor(@Nonnull ITaxable taxable) {
        return TaxDataCache.TYPE.get(taxable.isClient()).getAllEntries().stream().filter(e -> e.ShouldTax(taxable)).map(e -> e).toList();
    }

    @Override
    @Nonnull
    public List<ITaxCollector> GetPotentialTaxCollectorsFor(@Nonnull ITaxable taxable) {
        return TaxDataCache.TYPE.get(taxable.isClient()).getAllEntries().stream().filter(e -> e.IsInArea(taxable)).map(e -> e).toList();
    }

    @Override
    @Nonnull
    public List<ITaxCollector> AcknowledgeTaxCollectors(@Nonnull ITaxable taxable) {
        List<ITaxCollector> taxCollectors = this.GetPotentialTaxCollectorsFor(taxable);
        taxCollectors.forEach(c -> c.AcceptTaxable(taxable));
        return taxCollectors;
    }
}

