/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.ListLikeOption;
import io.github.lightman314.lightmanscurrency.api.config.options.MapLikeOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.common.data.types.TraderDataCache;
import io.github.lightman314.lightmanscurrency.common.seasonal_events.SeasonalEventManager;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketEditConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketEditListConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketEditMapConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketReloadConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketResetConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketViewConfig;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class CommandConfig {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder configReloadCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"lcconfig").then(Commands.literal((String)"reload").executes(CommandConfig::reload))).then(CommandConfig.configEditCommands())).then(CommandConfig.configResetCommands())).then(CommandConfig.configViewCommands());
        dispatcher.register(configReloadCommand);
    }

    static int reload(CommandContext<CommandSourceStack> commandContext) {
        ServerPlayer player;
        int result = 0;
        boolean involveAdmins = false;
        if (((CommandSourceStack)commandContext.getSource()).hasPermission(2)) {
            involveAdmins = true;
            CoinAPI.API.ReloadCoinDataFromFile();
            ConfigFile.reloadServerFiles();
            TraderDataCache.TYPE.get(false).reloadPersistentTraders();
            SeasonalEventManager.reload();
            ++result;
        }
        if ((player = ((CommandSourceStack)commandContext.getSource()).getPlayer()) != null) {
            SPacketReloadConfig.INSTANCE.sendTo(player);
            ++result;
        }
        if (result > 0) {
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_RELOAD.get(new Object[0]), involveAdmins);
        }
        return result;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> configEditCommands() {
        LiteralArgumentBuilder edit = Commands.literal((String)"edit");
        for (ConfigFile file : ConfigFile.getAvailableFiles()) {
            LiteralArgumentBuilder fileSection = (LiteralArgumentBuilder)Commands.literal((String)file.getFileID().toString()).requires(stack -> file.isClientOnly() ? stack.isPlayer() : stack.hasPermission(2));
            file.getAllOptions().forEach((key, option) -> {
                if (option instanceof ListLikeOption) {
                    fileSection.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)key).then(Commands.literal((String)"add").then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> CommandConfig.commandEditList((CommandContext<CommandSourceStack>)context, file, key, -1, true))))).then(Commands.literal((String)"replace").then(Commands.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> CommandConfig.commandEditList((CommandContext<CommandSourceStack>)context, file, key, IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), true)))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> CommandConfig.commandEditList((CommandContext<CommandSourceStack>)context, file, key, IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), false)))));
                } else if (option instanceof MapLikeOption) {
                    fileSection.then(((LiteralArgumentBuilder)Commands.literal((String)key).then(Commands.literal((String)"set").then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> CommandConfig.commandEditMap((CommandContext<CommandSourceStack>)context, file, key, true)))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.string()).executes(context -> CommandConfig.commandEditMap((CommandContext<CommandSourceStack>)context, file, key, false)))));
                } else {
                    fileSection.then(Commands.literal((String)key).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> CommandConfig.commandEdit((CommandContext<CommandSourceStack>)context, file, key))));
                }
            });
            edit.then((ArgumentBuilder)fileSection);
        }
        return edit;
    }

    static int commandEdit(CommandContext<CommandSourceStack> commandContext, ConfigFile file, String configOption) throws CommandSyntaxException {
        String input = StringArgumentType.getString(commandContext, (String)"value");
        if (file.isClientOnly()) {
            new SPacketEditConfig(file.getFileID(), configOption, input).sendTo(((CommandSourceStack)commandContext.getSource()).getPlayerOrException());
            return 1;
        }
        Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
        if (optionMap.containsKey(configOption)) {
            ConfigOption<?> option = optionMap.get(configOption);
            Pair<Boolean, ConfigParsingException> result = option.load(input, ConfigOption.LoadSource.COMMAND);
            if (!((Boolean)result.getFirst()).booleanValue()) {
                EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_EDIT_FAIL_PARSE.get(((ConfigParsingException)result.getSecond()).getMessage()));
                return 0;
            }
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_EDIT_SUCCESS.get(option.getName(), input), true);
            return 1;
        }
        EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_FAIL_MISSING.get(configOption));
        return 0;
    }

    static int commandEditList(CommandContext<CommandSourceStack> commandContext, ConfigFile file, String configOption, int listIndex, boolean isEdit) throws CommandSyntaxException {
        ConfigOption<?> configOption2;
        String input = isEdit ? StringArgumentType.getString(commandContext, (String)"value") : "";
        if (file.isClientOnly()) {
            new SPacketEditListConfig(file.getFileID(), configOption, input, listIndex, isEdit).sendTo(((CommandSourceStack)commandContext.getSource()).getPlayerOrException());
            return 1;
        }
        Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
        if (optionMap.containsKey(configOption) && (configOption2 = optionMap.get(configOption)) instanceof ListLikeOption) {
            ListLikeOption option = (ListLikeOption)configOption2;
            Pair<Boolean, ConfigParsingException> result = option.editList(input, listIndex, isEdit);
            if (!((Boolean)result.getFirst()).booleanValue()) {
                EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_EDIT_FAIL_PARSE.get(((ConfigParsingException)result.getSecond()).getMessage()));
                return 0;
            }
            if (!isEdit) {
                EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_EDIT_LIST_REMOVE_SUCCESS.get(configOption + "[" + listIndex + "]"), true);
            }
            if (listIndex < 0) {
                listIndex = option.getSize() - 1;
            }
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_EDIT_SUCCESS.get(configOption + "[" + listIndex + "]", input), true);
            return 1;
        }
        EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_FAIL_MISSING.get(configOption));
        return 0;
    }

    static int commandEditMap(CommandContext<CommandSourceStack> commandContext, ConfigFile file, String configOption, boolean isSet) throws CommandSyntaxException {
        ConfigOption<?> configOption2;
        String input = isSet ? StringArgumentType.getString(commandContext, (String)"value") : "";
        String key = StringArgumentType.getString(commandContext, (String)"key");
        if (file.isClientOnly()) {
            new SPacketEditMapConfig(file.getFileID(), configOption, input, key, isSet).sendTo(((CommandSourceStack)commandContext.getSource()).getPlayerOrException());
            return 1;
        }
        Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
        if (optionMap.containsKey(configOption) && (configOption2 = optionMap.get(configOption)) instanceof MapLikeOption) {
            MapLikeOption option = (MapLikeOption)configOption2;
            Pair<Boolean, ConfigParsingException> result = option.editMap(input, key, isSet);
            if (!((Boolean)result.getFirst()).booleanValue()) {
                EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_EDIT_FAIL_PARSE.get(((ConfigParsingException)result.getSecond()).getMessage()));
                return 0;
            }
            if (!isSet) {
                EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_EDIT_LIST_REMOVE_SUCCESS.get(configOption + "[" + key + "]"), true);
            }
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_EDIT_SUCCESS.get(configOption + "[" + key + "]", input), true);
            return 1;
        }
        EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_FAIL_MISSING.get(configOption));
        return 0;
    }

    public static ArgumentBuilder<CommandSourceStack, ?> configResetCommands() {
        LiteralArgumentBuilder view = Commands.literal((String)"reset");
        for (ConfigFile file : ConfigFile.getAvailableFiles()) {
            LiteralArgumentBuilder fileSection = (LiteralArgumentBuilder)Commands.literal((String)file.getFileID().toString()).requires(stack -> file.isClientOnly() ? stack.isPlayer() : stack.hasPermission(2));
            file.getAllOptions().forEach((key, option) -> fileSection.then(Commands.literal((String)key).executes(context -> CommandConfig.commandReset((CommandContext<CommandSourceStack>)context, file, key))));
            view.then((ArgumentBuilder)fileSection);
        }
        return view;
    }

    static int commandReset(CommandContext<CommandSourceStack> commandContext, ConfigFile file, String configOption) throws CommandSyntaxException {
        if (file.isClientOnly()) {
            new SPacketResetConfig(file.getFileID(), configOption).sendTo(((CommandSourceStack)commandContext.getSource()).getPlayerOrException());
            return 1;
        }
        Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
        if (optionMap.containsKey(configOption)) {
            ConfigOption<?> option = optionMap.get(configOption);
            option.setToDefault();
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_EDIT_SUCCESS.get(option.getName(), option.write()), true);
            return 1;
        }
        EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_FAIL_MISSING.get(configOption));
        return 0;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> configViewCommands() {
        LiteralArgumentBuilder view = Commands.literal((String)"view");
        for (ConfigFile file : ConfigFile.getAvailableFiles()) {
            LiteralArgumentBuilder fileSection = (LiteralArgumentBuilder)Commands.literal((String)file.getFileID().toString()).requires(stack -> stack.isPlayer() || !file.isClientOnly());
            file.getAllOptions().forEach((key, option) -> fileSection.then(Commands.literal((String)key).executes(context -> CommandConfig.commandView((CommandContext<CommandSourceStack>)context, file, key))));
            view.then((ArgumentBuilder)fileSection);
        }
        return view;
    }

    static int commandView(CommandContext<CommandSourceStack> commandContext, ConfigFile file, String configOption) throws CommandSyntaxException {
        if (file.isClientOnly()) {
            new SPacketViewConfig(file.getFileID(), configOption).sendTo(((CommandSourceStack)commandContext.getSource()).getPlayerOrException());
            return 1;
        }
        Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
        if (optionMap.containsKey(configOption)) {
            ConfigOption<?> option = optionMap.get(configOption);
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_VIEW.get(option.getName()), false);
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)EasyText.literal(option.write()), false);
            return 1;
        }
        EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)LCText.COMMAND_CONFIG_FAIL_MISSING.get(configOption));
        return 0;
    }
}

