/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.bank.BankAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CommandBalTop {
    public static final Comparator<IBankAccount> SORTER = new AccountSorter();
    public static final int ENTRIES_PER_PAGE = 10;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder lcAdminCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"lcbaltop").executes(context -> CommandBalTop.execute((CommandContext<CommandSourceStack>)context, 1))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(CommandBalTop::executePage));
        dispatcher.register(lcAdminCommand);
    }

    static int executePage(CommandContext<CommandSourceStack> commandContext) {
        return CommandBalTop.execute(commandContext, IntegerArgumentType.getInteger(commandContext, (String)"page"));
    }

    static int execute(CommandContext<CommandSourceStack> commandContext, int page) {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        List<IBankAccount> allAccounts = BankAPI.API.GetAllBankAccounts(false);
        allAccounts.removeIf(ba -> {
            if (ba == null) {
                return true;
            }
            return ba.getMoneyStorage().isEmpty();
        });
        if (allAccounts.isEmpty()) {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_BALTOP_NO_RESULTS.get(new Object[0]));
            return 0;
        }
        allAccounts.sort(SORTER);
        int startIndex = (page - 1) * 10;
        if (startIndex >= allAccounts.size()) {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_BALTOP_ERROR_PAGE.get(new Object[0]));
            return 0;
        }
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_BALTOP_TITLE.get(new Object[0]).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GOLD), false);
        EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_BALTOP_PAGE.get(page, CommandBalTop.getMaxPage(allAccounts.size())).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GOLD), false);
        for (int i = startIndex; i < startIndex + 10 && i < allAccounts.size(); ++i) {
            try {
                IBankAccount account = allAccounts.get(i);
                MutableComponent name = account.getName();
                Component amount = account.getMoneyStorage().getAllValueText();
                EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_BALTOP_ENTRY.get(i + 1, name, amount), false);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1;
    }

    private static int getMaxPage(int listSize) {
        return (listSize - 1) / 10 + 1;
    }

    private static class AccountSorter
    implements Comparator<IBankAccount> {
        private AccountSorter() {
        }

        @Override
        public int compare(IBankAccount a1, IBankAccount a2) {
            long bal1 = 0L;
            for (MoneyValue val : a1.getMoneyStorage().allValues()) {
                bal1 += val.getCoreValue();
            }
            long bal2 = 0L;
            for (MoneyValue val : a2.getMoneyStorage().allValues()) {
                bal2 += val.getCoreValue();
            }
            if (bal1 > bal2) {
                return -1;
            }
            if (bal2 > bal1) {
                return 1;
            }
            return a1.getName().getString().toLowerCase().compareTo(a2.getName().getString().toLowerCase());
        }
    }
}

