/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.blocks.TraderBlockRotatable;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.PaygateBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.variant.IVariantBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class PaygateBlock
extends TraderBlockRotatable
implements IVariantBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public PaygateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public int modelsRequiringRotation() {
        return 2;
    }

    @Override
    public int getModelIndex(BlockState state) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            return 1;
        }
        return 0;
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        PaygateTraderData trader;
        PaygateBlockEntity paygate;
        int tradeIndex;
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof PaygateBlockEntity && (tradeIndex = (paygate = (PaygateBlockEntity)blockEntity).getValidTicketTrade(player, stack)) >= 0 && (trader = (PaygateTraderData)paygate.getTraderData()) != null && trader.TryExecuteTrade(TradeContext.create((TraderData)trader, player).build(), tradeIndex).isSuccess()) {
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    @Override
    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
    }

    public boolean isSignalSource(@Nonnull BlockState state) {
        return true;
    }

    public int getSignal(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull Direction dir) {
        Direction relativeSide;
        PaygateBlockEntity be;
        BlockEntity blockEntity;
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof PaygateBlockEntity && (be = (PaygateBlockEntity)blockEntity).allowOutputSide(relativeSide = IRotatableBlock.getRelativeSide(this.getFacing(state), dir.getOpposite()))) {
            return be.getPowerLevel(relativeSide);
        }
        return 0;
    }

    @Override
    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        TooltipItem.addTooltip(tooltip, LCText.TOOLTIP_PAYGATE.asTooltip(new Object[0]));
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    @Override
    protected BlockEntity makeTrader(BlockPos pos, BlockState state) {
        return new PaygateBlockEntity(pos, state);
    }

    @Override
    protected BlockEntityType<?> traderType() {
        return ModBlockEntities.PAYGATE.get();
    }
}

