/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IEasyEntityBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.LazyShapes;
import io.github.lightman314.lightmanscurrency.common.blockentity.MoneyBagBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.data.types.LootTableEntry;
import io.github.lightman314.lightmanscurrency.common.items.MoneyBagItem;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Range;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MoneyBagBlock
extends FallingBlock
implements IRotatableBlock,
IEasyEntityBlock {
    public static final IntegerProperty SIZE = IntegerProperty.create((String)"size", (int)0, (int)3);
    public static final ImmutableList<VoxelShape> SHAPES = ImmutableList.of((Object)MoneyBagBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), (Object)MoneyBagBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0), (Object)MoneyBagBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0), (Object)LazyShapes.BOX_T);

    public MoneyBagBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return MoneyBagBlock.simpleCodec(MoneyBagBlock::new);
    }

    @Nonnull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Override
    public int getRotationY(Direction facing) {
        return this.getRotationYInv(facing);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING}).add(new Property[]{SIZE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)SIZE, (Comparable)Integer.valueOf(MoneyBagItem.getSize(context.getItemInHand())));
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    protected VoxelShape shapeForSize(int size) {
        return (VoxelShape)SHAPES.get(size);
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeForSize((Integer)state.getValue((Property)SIZE));
    }

    @Override
    @Nonnull
    public Collection<BlockEntityType<?>> getAllowedTypes() {
        return Lists.newArrayList((Object[])new BlockEntityType[]{ModBlockEntities.MONEY_BAG.get()});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MoneyBagBlockEntity(pos, state);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MoneyBagBlockEntity) {
            MoneyBagBlockEntity be = (MoneyBagBlockEntity)blockEntity;
            be.loadFromItem(stack);
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof MoneyBagBlockEntity) {
            MoneyBagBlockEntity be = (MoneyBagBlockEntity)blockEntity;
            if (be.tryInsertItem(stack, player)) {
                stack.shrink(1);
                level.playSound(null, pos, ModSounds.COINS_CLINKING.get(), SoundSource.BLOCKS, 0.25f, 1.0f);
            }
            level.playSound(null, pos, (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.BLOCKS, 0.5f, 1.0f);
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof MoneyBagBlockEntity) {
            MoneyBagBlockEntity be = (MoneyBagBlockEntity)blockEntity;
            ItemStack taken = be.removeRandomItem();
            if (!taken.isEmpty()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)taken);
                level.playSound(null, pos, ModSounds.COINS_CLINKING.get(), SoundSource.BLOCKS, 0.25f, 1.0f);
            }
            level.playSound(null, pos, (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.BLOCKS, 0.5f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (state.is(newState.getBlock())) {
            super.onRemove(state, level, pos, newState, movedByPiston);
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MoneyBagBlockEntity) {
            MoneyBagBlockEntity be = (MoneyBagBlockEntity)blockEntity;
            if (be.shouldDropItem) {
                int size = be.getBlockSize();
                List<ItemStack> contents = be.clearContents();
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)MoneyBagItem.createItem((ItemLike)this, contents, size));
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        if (player.isCreative() && player.isCrouching() && (blockEntity = level.getBlockEntity(pos)) instanceof MoneyBagBlockEntity) {
            MoneyBagBlockEntity be = (MoneyBagBlockEntity)blockEntity;
            be.copyContentsTo(stack);
        }
        return stack;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity;
        if (MoneyBagBlock.isFree((BlockState)level.getBlockState(pos.below())) && pos.getY() >= level.getMinBuildHeight() && (blockEntity = level.getBlockEntity(pos)) instanceof MoneyBagBlockEntity) {
            MoneyBagBlockEntity be = (MoneyBagBlockEntity)blockEntity;
            be.shouldDropItem = false;
            FallingBlockEntity fallingBlock = FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)state);
            fallingBlock.blockData = be.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            int size = be.getBlockSize();
            float damagePerDistance = ((Float)LCConfig.SERVER.moneyBagBaseFallDamage.get()).floatValue() + (float)size * ((Float)LCConfig.SERVER.moneyBagFallDamagerPerSize.get()).floatValue();
            int damageLimit = (Integer)LCConfig.SERVER.moneyBagMaxFallDamageBase.get() + size * (Integer)LCConfig.SERVER.moneyBagMaxFallDamagePerSize.get();
            if (damagePerDistance > 0.0f && damageLimit > 0) {
                fallingBlock.setHurtsEntities(damagePerDistance, damageLimit);
            }
            this.falling(fallingBlock);
        }
    }

    public void onLand(Level level, BlockPos pos, BlockState state, BlockState replaceableState, FallingBlockEntity fallingBlock) {
        BlockEntity blockEntity;
        BlockPos startPos = fallingBlock.getStartPos();
        int fall = startPos.getY() - pos.getY();
        LightmansCurrency.LogDebug("Money Bag fell " + fall + "m");
        if (fall >= (Integer)LCConfig.SERVER.moneyBagCoinLossFallDistance.get() && (blockEntity = level.getBlockEntity(pos)) instanceof MoneyBagBlockEntity) {
            MoneyBagBlockEntity be = (MoneyBagBlockEntity)blockEntity;
            int testCount = Math.round((float)fall * 2.0f);
            double dropChance = (Double)LCConfig.SERVER.moneyBagCoinLossChance.get();
            if (dropChance <= 0.0) {
                return;
            }
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            RandomSource random = level.getRandom();
            for (int i = 0; i < testCount && !be.isEmpty(); ++i) {
                if (!(random.nextDouble() < dropChance)) continue;
                drops.add(be.removeRandomItem());
            }
            if (!drops.isEmpty()) {
                LightmansCurrency.LogDebug("Money Bag dropped " + drops.size() + " coins after landing");
                Vec3 itemSpawn = MoneyBagBlock.getDropPosition(pos, (Integer)state.getValue((Property)SIZE));
                for (ItemStack item : drops) {
                    ItemEntity entity = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), item);
                    entity.setDeltaMovement(random.triangle(0.0, 0.5), (double)fall * 0.25 + random.triangle(2.0, 1.0), random.triangle(0.0, 0.5));
                    level.addFreshEntity((Entity)entity);
                }
            }
        }
    }

    public static Vec3 getDropPosition(BlockPos pos, @Range(from=0L, to=3L) int size) {
        Vec3 center = pos.getBottomCenter();
        return switch (size) {
            case 0 -> center.add(0.0, 0.4375, 0.0);
            case 1 -> center.add(0.0, 0.625, 0.0);
            case 2 -> center.add(0.0, 0.75, 0.0);
            default -> center.add(0.0, 1.0625, 0.0);
        };
    }

    public ItemStack getDropItem(ItemStack stack, CompoundTag tag, HolderLookup.Provider lookup) {
        if (stack == null || stack.isEmpty() || !stack.is(this.asItem())) {
            return stack;
        }
        if (tag.contains("CustomName")) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.Serializer.fromJson((String)tag.getString("CustomName"), (HolderLookup.Provider)lookup));
        }
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
        ListTag list = tag.getList("Contents", 10);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = InventoryUtil.loadItemNoLimits(list.getCompound(i), lookup);
            if (item.isEmpty()) continue;
            contents.add(item);
        }
        MoneyBagItem.setContents(stack, contents);
        if (tag.contains("LootTable")) {
            ResourceKey lootTable = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)VersionUtil.parseResource(tag.getString("LootTable")));
            long lootTableSeed = -1L;
            if (tag.contains("LootTableSeed")) {
                lootTableSeed = tag.getLong("LootTableSeed");
            }
            stack.set(ModDataComponents.LOOT_TABLE_ENTRY, (Object)new LootTableEntry((ResourceKey<LootTable>)lootTable, lootTableSeed));
        }
        return stack;
    }
}

