/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.advancements.date;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lightman314.lightmanscurrency.common.advancements.date.DatePredicate;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class DateTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = VersionUtil.lcResource("date_range");
    public static final DateTrigger INSTANCE = new DateTrigger();
    private static final Codec<Instance> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)DatePredicate.CODEC.fieldOf("start").forGetter(i -> i.startDate), (App)DatePredicate.CODEC.fieldOf("end").forGetter(i -> i.endDate)).apply((Applicative)builder, Instance::new));

    private DateTrigger() {
    }

    public static Criterion<Instance> ofRange(int startMonth, int startDate, int endMonth, int endDate) {
        return INSTANCE.createCriterion((CriterionTriggerInstance)new Instance(Optional.empty(), new DatePredicate(startMonth, startDate), new DatePredicate(endMonth, endDate)));
    }

    public static Criterion<Instance> ofRange(@Nonnull DatePredicate startDate, @Nonnull DatePredicate endDate) {
        return INSTANCE.createCriterion((CriterionTriggerInstance)new Instance(Optional.empty(), startDate, endDate));
    }

    @Nonnull
    public Codec<Instance> codec() {
        return CODEC;
    }

    public void trigger(@Nonnull ServerPlayer player) {
        this.trigger(player, Instance::test);
    }

    public static class Instance
    implements SimpleCriterionTrigger.SimpleInstance {
        private final Optional<ContextAwarePredicate> player;
        private final DatePredicate startDate;
        private final DatePredicate endDate;

        public Instance(Optional<ContextAwarePredicate> player, DatePredicate startDate, DatePredicate endDate) {
            this.player = player;
            this.startDate = startDate;
            this.endDate = endDate;
        }

        public boolean test() {
            return DatePredicate.isInRange(this.startDate, this.endDate);
        }

        public void validate(@Nonnull CriterionValidator validator) {
        }

        @Nonnull
        public Optional<ContextAwarePredicate> player() {
            return this.player;
        }
    }
}

