/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.builtin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantPropertyWithDefault;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.util.GsonHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public record ShowInCreative(boolean show, boolean locked) {
    public static final ShowInCreative FALSE = new ShowInCreative(false, false);
    public static final ShowInCreative TRUE = new ShowInCreative(true, false);
    public static final ShowInCreative LOCKED = new ShowInCreative(true, true);
    public static final VariantPropertyWithDefault<ShowInCreative> PROPERTY = new Property();

    private static class Property
    extends VariantPropertyWithDefault<ShowInCreative> {
        private Property() {
        }

        @Override
        public ShowInCreative getMissingDefault() {
            return FALSE;
        }

        @Override
        public ShowInCreative getBuilderDefault() {
            return TRUE;
        }

        @Override
        public ShowInCreative parse(JsonElement element) throws JsonSyntaxException, ResourceLocationException {
            if (element.isJsonPrimitive()) {
                return GsonHelper.convertToBoolean((JsonElement)element, (String)this.getID().toString()) ? TRUE : FALSE;
            }
            JsonObject object = GsonHelper.convertToJsonObject((JsonElement)element, (String)this.getID().toString());
            boolean locked = GsonHelper.getAsBoolean((JsonObject)object, (String)"locked");
            return new ShowInCreative(true, locked);
        }

        @Override
        public JsonElement write(Object value) {
            if (value instanceof ShowInCreative) {
                ShowInCreative sic = (ShowInCreative)value;
                if (sic.locked && sic.show) {
                    JsonObject result = new JsonObject();
                    result.addProperty("locked", Boolean.valueOf(sic.locked));
                    return result;
                }
                return new JsonPrimitive(Boolean.valueOf(sic.show));
            }
            if (value instanceof Boolean) {
                Boolean bool = (Boolean)value;
                return new JsonPrimitive(bool);
            }
            throw new IllegalArgumentException("Value must be an ShowInCreative element!");
        }
    }
}

