/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.models;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.models.VariantModelLocation;
import io.github.lightman314.lightmanscurrency.common.blocks.variant.IVariantBlock;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class VariantModelHelper {
    private VariantModelHelper() {
    }

    @Nullable
    public static VariantModelLocation getModelID(ModelVariant variant, ResourceLocation variantID, IVariantBlock block, BlockState state) {
        if (state == null) {
            return VariantModelLocation.item(variantID, block.getBlockID());
        }
        int index = block.getModelIndex(state);
        if (index < block.modelsRequiringRotation() && block instanceof IRotatableBlock) {
            IRotatableBlock rb = (IRotatableBlock)((Object)block);
            return VariantModelLocation.rotatable(variantID, block.getBlockID(), index, rb.getRotationY(state));
        }
        return VariantModelLocation.basic(variantID, block.getBlockID(), index);
    }

    public static List<ResourceLocation> createCustomBlockModel(List<ResourceLocation> originalModels, Map<ResourceLocation, BlockModel> modelData, Map<String, ResourceLocation> textureOverrides, Function<String, ResourceLocation> idGenerator) {
        ArrayList<ResourceLocation> newModels = new ArrayList<ResourceLocation>();
        for (int i = 0; i < originalModels.size(); ++i) {
            ResourceLocation model = originalModels.get(i);
            ResourceLocation newModelID = idGenerator.apply(String.valueOf(i));
            VariantModelHelper.createCustomBlockModel(model, modelData, textureOverrides, newModelID);
            newModels.add(newModelID);
        }
        return newModels;
    }

    public static void createCustomBlockModel(ResourceLocation model, Map<ResourceLocation, BlockModel> modelData, Map<String, ResourceLocation> textureOverrides, ResourceLocation newModelID) {
        ResourceLocation fileID = ModelBakery.MODEL_LISTER.idToFile(newModelID);
        if (modelData.containsKey(fileID)) {
            return;
        }
        HashMap textureMap = new HashMap();
        textureOverrides.forEach((key, texture) -> textureMap.put(key, Either.left((Object)new Material(InventoryMenu.BLOCK_ATLAS, texture))));
        BlockModel newModel = new BlockModel(model, new ArrayList(), textureMap, null, null, ItemTransforms.NO_TRANSFORMS, new ArrayList());
        modelData.put(fileID, newModel);
    }

    public static List<ResourceLocation> getDefaultModels(Block b, IVariantBlock block, Map<ResourceLocation, List<BlockStateModelLoader.LoadedJson>> blockStateData, BiFunction<StateDefinition<Block, BlockState>, String, Predicate<BlockState>> tester) {
        ResourceLocation fileID = BlockStateModelLoader.BLOCKSTATE_LISTER.idToFile(block.getBlockID());
        List blockStates = blockStateData.getOrDefault(fileID, new ArrayList());
        NonNullList models = NonNullList.withSize((int)block.requiredModels(), (Object)VersionUtil.vanillaResource("null"));
        ArrayList completedIndexes = new ArrayList();
        BlockModelDefinition.Context context = new BlockModelDefinition.Context();
        context.setDefinition(b.getStateDefinition());
        if (blockStates.isEmpty()) {
            LightmansCurrency.LogWarning("No Block States json file found for " + String.valueOf(block.getBlockID()));
        }
        for (BlockStateModelLoader.LoadedJson json : blockStates) {
            try {
                BlockModelDefinition definition = BlockModelDefinition.fromJsonElement((BlockModelDefinition.Context)context, (JsonElement)json.data());
                ArrayList allStates = new ArrayList(b.getStateDefinition().getPossibleStates());
                definition.getVariants().forEach((arg_0, arg_1) -> VariantModelHelper.lambda$getDefaultModels$1(allStates, tester, context, block, completedIndexes, (List)models, arg_0, arg_1));
            }
            catch (Exception e) {
                LightmansCurrency.LogWarning("Error parsing Block Model Definition for " + String.valueOf(block.getBlockID()), e);
            }
        }
        for (int i = block.modelsRequiringRotation(); i < block.requiredModels(); ++i) {
            models.set(i, block.getCustomDefaultModel(i));
        }
        return models;
    }

    public static Function<String, ResourceLocation> createIDGenerator(ResourceLocation variantID, @Nullable ResourceLocation target) {
        if (target == null) {
            return s -> VersionUtil.modResource(variantID.getNamespace(), "lc_model_variants/" + variantID.getPath() + "/" + s);
        }
        return s -> VersionUtil.modResource(variantID.getNamespace(), "lc_model_variants/" + variantID.getPath() + "/" + target.getNamespace() + "/" + target.getPath() + "/" + s);
    }

    private static /* synthetic */ void lambda$getDefaultModels$1(List allStates, BiFunction tester, BlockModelDefinition.Context context, IVariantBlock block, List completedIndexes, List models, String key, MultiVariant mv) {
        List applicableStates = allStates.stream().filter((Predicate)tester.apply(context.getDefinition(), key)).toList();
        block0: for (BlockState state : applicableStates) {
            int index = block.getModelIndex(state);
            if (completedIndexes.contains(index)) continue;
            for (Variant v : mv.getVariants()) {
                if (v.getModelLocation() == null) continue;
                models.set(index, v.getModelLocation());
                completedIndexes.add(index);
                continue block0;
            }
        }
    }
}

