/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.scroll;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IPreRender;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;

public class ScrollBarWidget
extends EasyWidget
implements IMouseListener,
IPreRender {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/scroll.png");
    public static final int WIDTH = 8;
    public static final int KNOB_HEIGHT = 29;
    public static final int SMALL_KNOB_HEIGHT = 9;
    private final IScrollable scrollable;
    private final boolean smallKnob;
    public boolean isDragging = false;

    private int getKnobHeight() {
        return this.smallKnob ? 9 : 29;
    }

    private ScrollBarWidget(@Nonnull Builder builder) {
        super(builder);
        this.scrollable = builder.scrollable;
        this.smallKnob = builder.smallKnob;
    }

    @Deprecated
    @Nonnull
    public static <T extends EasyWidget> ScrollBarWidget createOnRight(@Nonnull T widget) {
        return ScrollBarWidget.builder().onRight(widget).build();
    }

    public boolean visible() {
        return this.visible && this.scrollable.getMaxScroll() > this.scrollable.getMinScroll();
    }

    @Override
    protected void renderTick() {
        if (!this.visible() && this.isDragging) {
            this.isDragging = false;
        }
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        int yPart;
        if (!this.visible()) {
            return;
        }
        gui.resetColor();
        gui.blit(GUI_TEXTURE, 0, 0, 0, 0, 8, 8);
        for (int yOffset = 8; yOffset < this.height - 8; yOffset += yPart) {
            yPart = Math.min(this.height - 8 - yOffset, 240);
            gui.blit(GUI_TEXTURE, 0, yOffset, 0, 8, 8, yPart);
        }
        gui.blit(GUI_TEXTURE, 0, this.height - 8, 0, 248, 8, 8);
        int knobPosition = this.isDragging ? MathUtil.clamp(gui.mousePos.y - this.getY() - this.getKnobHeight() / 2, 0, this.height - this.getKnobHeight()) : this.getNaturalKnobPosition();
        gui.blit(GUI_TEXTURE, 0, knobPosition, this.smallKnob ? 16 : 8, 0, 8, this.getKnobHeight());
    }

    @Override
    public void preRender(@Nonnull EasyGuiGraphics gui) {
        if (this.isDragging) {
            this.dragKnob(gui.mousePos.y);
        }
    }

    private int getNaturalKnobPosition() {
        int notches = this.scrollable.getMaxScroll() - this.scrollable.getMinScroll();
        if (notches <= 0) {
            return 0;
        }
        double spacing = (double)(this.height - this.getKnobHeight()) / (double)notches;
        int scroll = this.scrollable.currentScroll() - this.scrollable.getMinScroll();
        return (int)Math.round((double)scroll * spacing);
    }

    protected void dragKnob(double mouseY) {
        if (!this.visible()) {
            this.isDragging = false;
            return;
        }
        int scroll = this.getScrollFromMouse(mouseY);
        if (this.scrollable.currentScroll() != scroll) {
            this.scrollable.setScroll(scroll);
        }
    }

    private int getScrollFromMouse(double mouseY) {
        if ((mouseY -= (double)this.getKnobHeight() / 2.0) <= (double)this.getY()) {
            return this.scrollable.getMinScroll();
        }
        if (mouseY >= (double)(this.getY() + this.height - this.getKnobHeight())) {
            return this.scrollable.getMaxScroll();
        }
        int deltaScroll = this.scrollable.getMaxScroll() - this.scrollable.getMinScroll();
        if (deltaScroll <= 0) {
            return Integer.MIN_VALUE;
        }
        double sectionHeight = (double)(this.height - this.getKnobHeight()) / (double)deltaScroll;
        double yPos = (double)this.getY() - sectionHeight / 2.0;
        for (int i = this.scrollable.getMinScroll(); i <= this.scrollable.getMaxScroll(); ++i) {
            if (mouseY >= yPos && mouseY < yPos + sectionHeight) {
                return i;
            }
            yPos += sectionHeight;
        }
        LightmansCurrency.LogWarning("Error getting scroll from mouse position.");
        return this.scrollable.getMinScroll();
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        if (this.isMouseOver(mouseX, mouseY) && this.visible() && button == 0) {
            this.isDragging = true;
            this.dragKnob(mouseY);
        }
        return false;
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        if (this.isDragging && this.visible() && button == 0) {
            this.dragKnob(mouseY);
            this.isDragging = false;
        }
        return false;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @MethodsReturnNonnullByDefault
    @FieldsAreNonnullByDefault
    public static class Builder
    extends EasyWidget.EasyBuilder<Builder> {
        private boolean smallKnob = false;
        private IScrollable scrollable = null;

        private Builder() {
            super(8, 20);
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder height(int height) {
            this.changeHeight(height);
            return this;
        }

        public <T extends EasyWidget> Builder onLeft(T widget) {
            return ((Builder)this.scrollable((IScrollable)((Object)widget)).position(widget.getPosition().offset(-8, 0))).height(widget.getHeight());
        }

        public <T extends EasyWidget> Builder onRight(T widget) {
            return ((Builder)this.scrollable((IScrollable)((Object)widget)).position(widget.getPosition().offset(widget.getWidth(), 0))).height(widget.getHeight());
        }

        public Builder scrollable(IScrollable scrollable) {
            this.scrollable = scrollable;
            return this;
        }

        public Builder smallKnob() {
            this.smallKnob = true;
            return this;
        }

        public ScrollBarWidget build() {
            return new ScrollBarWidget(this);
        }
    }
}

