/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class RuleToggleTab
extends TradeRulesClientSubTab
implements IScrollable {
    public static final int RULES_PER_PAGE = 6;
    private int scroll = 0;

    public RuleToggleTab(@Nonnull TradeRulesClientTab<?> parent) {
        super(parent);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        for (int i = 0; i < 6; ++i) {
            int index = i;
            this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(20, 25 + 18 * i))).pressAction(() -> this.PressManagerActiveButton(index))).sprite(IconAndButtonUtil.SPRITE_TOGGLE(() -> this.isRuleActive(index))).addon(EasyAddonHelper.visibleCheck(() -> this.isValidRuleIndex(index)))).build());
        }
        this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(screenArea.width - 20, 25))).height(108).scrollable(this).build());
        this.addChild(((ScrollListener.Builder)((ScrollListener.Builder)ScrollListener.builder().position(screenArea.pos)).size(screenArea.width, 150)).listener(this).build());
        this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width - 25, 5))).pressAction(this::ClickBackButton)).icon(IconUtil.ICON_BACK).addon(EasyAddonHelper.visibleCheck(this.commonTab::hasBackButton))).build());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString((Component)LCText.GUI_TRADE_RULES_LIST.get(new Object[0]), 20, 10, 0x404040);
        List<TradeRule> rules = this.getFilteredRules();
        for (int i = 0; i < 6; ++i) {
            int index = i + this.scroll;
            if (index >= rules.size()) continue;
            TradeRule rule = rules.get(index);
            rule.getIcon().render(gui, 30, 26 + 18 * i);
            gui.drawString((Component)rule.getName(), 48, 30 + 18 * i, 0x404040);
        }
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.PAPER);
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_TRADE_RULES_MANAGER.get(new Object[0]);
    }

    private boolean isRuleActive(int ruleIndex) {
        List<TradeRule> rules = this.getFilteredRules();
        if ((ruleIndex += this.scroll) < rules.size()) {
            return rules.get(ruleIndex).isActive();
        }
        return false;
    }

    private boolean isValidRuleIndex(int ruleIndex) {
        return (ruleIndex += this.scroll) >= 0 && ruleIndex < this.getFilteredRules().size();
    }

    void PressManagerActiveButton(int ruleIndex) {
        List<TradeRule> rules = this.getFilteredRules();
        if ((ruleIndex += this.scroll) < rules.size()) {
            TradeRule rule = rules.get(ruleIndex);
            this.commonTab.EditTradeRule(rule.type, this.builder().setBoolean("SetActive", !rule.isActive()));
        }
    }

    private void ClickBackButton(@Nonnull EasyButton button) {
        this.commonTab.goBack();
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(6, this.getTradeRules().size());
    }
}

