/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.TraderSettingsClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core.addons.MiscTabAddon;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class MiscTab
extends SettingsSubTab {
    PlainButton buttonAlwaysShowSearchBox;
    PlainButton buttonToggleBankLink;
    PlainButton buttonToggleNotifications;
    PlainButton buttonToggleChatNotifications;
    EasyButton buttonToggleTeamLevel;
    int yOffset = 0;
    private List<MiscTabAddon> addons = new ArrayList<MiscTabAddon>();

    public MiscTab(@Nonnull TraderSettingsClientTab parent) {
        super(parent);
    }

    public List<MiscTabAddon> getAddons() {
        TraderData trader = this.menu.getTrader();
        if (trader != null) {
            return trader.getMiscTabAddons();
        }
        return new ArrayList<MiscTabAddon>();
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconUtil.ICON_SETTINGS;
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_TRADER_SETTINGS_MISC.get(new Object[0]);
    }

    @Override
    public boolean canOpen() {
        return this.menu.hasPermission("editSettings");
    }

    @Override
    public boolean shouldRenderInventoryText() {
        return false;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        AtomicInteger nextYLevel = new AtomicInteger(15);
        this.addons = this.getAddons();
        this.addons.forEach(a -> a.initialize(this));
        this.addons.forEach(a -> a.onOpenBefore(this, screenArea, firstOpen, nextYLevel));
        this.yOffset = nextYLevel.get();
        this.buttonAlwaysShowSearchBox = this.addChild(((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(35, nextYLevel.getAndAdd(20)))).pressAction(this::ToggleShowSearchBox)).sprite(IconAndButtonUtil.SPRITE_CHECK(this::alwaysShowSearchBox)).build());
        this.buttonToggleBankLink = this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(35, nextYLevel.getAndAdd(20)))).pressAction(this::ToggleBankLink)).sprite(IconAndButtonUtil.SPRITE_CHECK(this::linkedToBank)).addon(EasyAddonHelper.visibleCheck(this::showBankLink))).addon(EasyAddonHelper.activeCheck(this::bankLinkPossible))).build());
        this.buttonToggleNotifications = this.addChild(((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(35, nextYLevel.getAndAdd(20)))).pressAction(this::ToggleNotifications)).sprite(IconAndButtonUtil.SPRITE_CHECK(this::notificationsEnabled)).build());
        this.buttonToggleChatNotifications = this.addChild(((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(35, nextYLevel.getAndAdd(25)))).pressAction(this::ToggleChatNotifications)).sprite(IconAndButtonUtil.SPRITE_CHECK(this::notificationsToChat)).build());
        this.buttonToggleTeamLevel = this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(20, nextYLevel.getAndAdd(25)))).width(screenArea.width - 40)).text(this::TeamLevelText).pressAction(this::ToggleTeamNotificationLevel)).addon(EasyAddonHelper.visibleCheck(this::teamLevelVisible))).build());
        this.addons.forEach(a -> a.onOpenAfter(this, screenArea, firstOpen, nextYLevel));
        this.tick();
    }

    @Override
    protected void onSubtabClose() {
        this.addons.forEach(a -> a.onClose(this));
    }

    private boolean notificationsEnabled() {
        TraderData t = this.menu.getTrader();
        return t != null && t.notificationsEnabled();
    }

    private boolean notificationsToChat() {
        TraderData t = this.menu.getTrader();
        return t != null && t.notificationsToChat();
    }

    private boolean alwaysShowSearchBox() {
        TraderData t = this.menu.getTrader();
        return t != null && t.alwaysShowSearchBox();
    }

    private boolean linkedToBank() {
        TraderData t = this.menu.getTrader();
        return t != null && t.linkedToBank.get() != false;
    }

    private boolean showBankLink() {
        TraderData t = this.menu.getTrader();
        return t.hasPermission(this.menu.getPlayer(), "bankLink") && t.canStoreMoney();
    }

    private boolean bankLinkPossible() {
        TraderData t = this.menu.getTrader();
        return t != null && (t.canLinkBankAccount() || t.linkedToBank.get() != false);
    }

    private boolean teamLevelVisible() {
        TraderData t = this.menu.getTrader();
        return t != null && t.getOwner().getValidOwner().hasNotificationLevels();
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        gui.drawString((Component)LCText.GUI_TRADER_SETTINGS_ENABLE_SHOW_SEARCH_BOX.get(new Object[0]), 47, this.yOffset + 1, 0x404040);
        if (this.menu.hasPermission("bankLink") && trader.canStoreMoney()) {
            gui.drawString((Component)LCText.GUI_SETTINGS_BANK_LINK.get(new Object[0]), 47, this.yOffset + 21, 0x404040);
        }
        gui.drawString((Component)LCText.GUI_TRADER_SETTINGS_NOTIFICATIONS_ENABLED.get(new Object[0]), 47, this.yOffset + 41, 0x404040);
        gui.drawString((Component)LCText.GUI_TRADER_SETTINGS_NOTIFICATIONS_CHAT.get(new Object[0]), 47, this.yOffset + 61, 0x404040);
        this.addons.forEach(a -> a.renderBG(this, gui));
    }

    @Override
    public void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        this.addons.forEach(a -> a.renderAfterWidgets(this, gui));
    }

    @Override
    public void tick() {
        this.addons.forEach(a -> a.tick(this));
    }

    private Component TeamLevelText() {
        TraderData trader = this.menu.getTrader();
        int level = trader == null ? 0 : trader.teamNotificationLevel();
        return LCText.GUI_TRADER_SETTINGS_NOTIFICATIONS_TARGET.get(Owner.getOwnerLevelBlurb(level));
    }

    private void ToggleNotifications(EasyButton button) {
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        this.sendMessage(this.builder().setBoolean("Notifications", !trader.notificationsEnabled()));
    }

    private void ToggleChatNotifications(EasyButton button) {
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        this.sendMessage(this.builder().setBoolean("NotificationsToChat", !trader.notificationsToChat()));
    }

    private void ToggleTeamNotificationLevel(EasyButton button) {
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        this.sendMessage(this.builder().setInt("TeamNotificationLevel", Team.NextBankLimit(trader.teamNotificationLevel())));
    }

    private void ToggleShowSearchBox(EasyButton button) {
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        this.sendMessage(this.builder().setBoolean("AlwaysShowSearchBox", !trader.alwaysShowSearchBox()));
    }

    private void ToggleBankLink(EasyButton button) {
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        this.sendMessage(this.builder().setBoolean("LinkToBankAccount", trader.linkedToBank.get() == false));
    }
}

