/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.core;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageScreen;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionHandler;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TradeButtonArea;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class BasicTradeEditClientTab<T extends BasicTradeEditTab>
extends TraderStorageClientTab<T>
implements TradeInteractionHandler {
    TradeButtonArea tradeDisplay;
    EasyButton buttonAddTrade;
    EasyButton buttonRemoveTrade;
    EasyButton buttonSelectAllTrades;
    EasyButton buttonOpenMultiEdit;

    public BasicTradeEditClientTab(Object screen, T commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconUtil.ICON_TRADELIST;
    }

    @Override
    public Component getTooltip() {
        return LCText.TOOLTIP_TRADER_EDIT_TRADES.get(new Object[0]);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        ((ITraderStorageScreen)this.screen).getRightEdgePositioner().removeWidgets(this.buttonSelectAllTrades, this.buttonOpenMultiEdit);
        this.tradeDisplay = this.addChild(((TradeButtonArea.Builder)((TradeButtonArea.Builder)TradeButtonArea.builder().position(screenArea.pos.offset(3, 17))).size(screenArea.width - 6, 111)).traderSource(((ITraderStorageMenu)this.menu)::getTrader).context(((ITraderStorageMenu)this.menu)::getContext).tradeFilter(((ITraderStorageMenu)this.menu).getTrader(), (ITraderStorageMenu)this.menu).title(screenArea.pos.offset(4, 6), screenArea.width - (this.addRemoveVisible() ? 28 : 8), true).interactionHandler(this).selectedState(((BasicTradeEditTab)this.commonTab)::isSelected).blockSearchBox().extraTooltips(this::tradeSelectTooltip).build());
        this.buttonAddTrade = this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(screenArea.width - 25, 4))).pressAction(this::AddTrade)).sprite(IconAndButtonUtil.SPRITE_PLUS).addon(EasyAddonHelper.visibleCheck(this::addRemoveVisible))).addon(EasyAddonHelper.activeCheck(this::addActive))).build());
        this.buttonRemoveTrade = this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(screenArea.width - 14, 4))).pressAction(this::RemoveTrade)).sprite(IconAndButtonUtil.SPRITE_MINUS).addon(EasyAddonHelper.visibleCheck(this::addRemoveVisible))).addon(EasyAddonHelper.activeCheck(this::removeActive))).build());
        this.buttonSelectAllTrades = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width, 20))).pressAction(((BasicTradeEditTab)this.commonTab)::SelectAllTrades)).icon(this::selectAllIcon).addon(EasyAddonHelper.visibleCheck(((BasicTradeEditTab)this.commonTab)::allowTradeSelection))).addon(EasyAddonHelper.tooltip(this::selectAllTooltip))).build());
        this.buttonOpenMultiEdit = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width, 40))).pressAction(((BasicTradeEditTab)this.commonTab)::OpenMultiEditTab)).icon(IconUtil.ICON_TRADER_ALT).addon(EasyAddonHelper.activeCheck(((BasicTradeEditTab)this.commonTab)::canOpenMultiEdit))).addon(EasyAddonHelper.visibleCheck(((BasicTradeEditTab)this.commonTab)::allowTradeSelection))).addon(EasyAddonHelper.tooltip(this::multiEditTooltip))).build());
        ((ITraderStorageScreen)this.screen).getRightEdgePositioner().addWidgets(this.buttonSelectAllTrades, this.buttonOpenMultiEdit);
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
    }

    @Override
    protected void closeAction() {
        ((ITraderStorageScreen)this.screen).getRightEdgePositioner().removeWidgets(this.buttonSelectAllTrades, this.buttonOpenMultiEdit);
    }

    private boolean addRemoveVisible() {
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        return trader != null && trader.canEditTradeCount();
    }

    private boolean addActive() {
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        return trader != null && trader.getTradeCount() < trader.getMaxTradeCount();
    }

    private boolean removeActive() {
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        return trader != null && trader.getTradeCount() > 1;
    }

    private List<Component> tradeSelectTooltip() {
        if (((BasicTradeEditTab)this.commonTab).allowTradeSelection()) {
            return Lists.newArrayList((Object[])new Component[]{LCText.TOOLTIP_TRADE_SELECT.getWithStyle(ChatFormatting.YELLOW)});
        }
        return null;
    }

    private IconData selectAllIcon() {
        return ((BasicTradeEditTab)this.commonTab).allTradesSelected() ? IconUtil.ICON_MINUS : IconUtil.ICON_PLUS;
    }

    private Component selectAllTooltip() {
        return ((BasicTradeEditTab)this.commonTab).allTradesSelected() ? LCText.TOOLTIP_TRADER_DESELECT_ALL_TRADES.get(new Object[0]) : LCText.TOOLTIP_TRADER_SELECT_ALL_TRADES.get(new Object[0]);
    }

    private Component multiEditTooltip() {
        return LCText.TOOLTIP_TRADER_OPEN_MULTI_EDIT_SELECTED.get(((BasicTradeEditTab)this.commonTab).selectedCount());
    }

    @Override
    public void HandleTradeInputInteraction(@Nonnull TraderData trader, @Nonnull TradeData trade, @Nonnull TradeInteractionData data, int index) {
        if (trader.hasPermission(((ITraderStorageMenu)this.menu).getPlayer(), "editTrades")) {
            if (data.ctrlHeld()) {
                ((BasicTradeEditTab)this.commonTab).ToggleTradeSelection(trader.indexOfTrade(trade));
            } else {
                trade.OnInputDisplayInteraction((BasicTradeEditTab)this.commonTab, index, data, ((ITraderStorageMenu)this.menu).getHeldItem());
            }
        } else {
            Permissions.PermissionWarning(((ITraderStorageMenu)this.menu).getPlayer(), "edit trade", "editTrades");
        }
    }

    @Override
    public void HandleTradeOutputInteraction(@Nonnull TraderData trader, @Nonnull TradeData trade, @Nonnull TradeInteractionData data, int index) {
        if (trader.hasPermission(((ITraderStorageMenu)this.menu).getPlayer(), "editTrades")) {
            if (data.ctrlHeld()) {
                ((BasicTradeEditTab)this.commonTab).ToggleTradeSelection(trader.indexOfTrade(trade));
            } else {
                trade.OnOutputDisplayInteraction((BasicTradeEditTab)this.commonTab, index, data, ((ITraderStorageMenu)this.menu).getHeldItem());
            }
        } else {
            Permissions.PermissionWarning(((ITraderStorageMenu)this.menu).getPlayer(), "edit trade", "editTrades");
        }
    }

    @Override
    public void HandleOtherTradeInteraction(@Nonnull TraderData trader, @Nonnull TradeData trade, @Nonnull TradeInteractionData data) {
        if (trader.hasPermission(((ITraderStorageMenu)this.menu).getPlayer(), "editTrades")) {
            if (data.ctrlHeld()) {
                ((BasicTradeEditTab)this.commonTab).ToggleTradeSelection(trader.indexOfTrade(trade));
            } else {
                trade.OnInteraction((BasicTradeEditTab)this.commonTab, data, ((ITraderStorageMenu)this.menu).getHeldItem());
            }
        } else {
            Permissions.PermissionWarning(((ITraderStorageMenu)this.menu).getPlayer(), "edit trade", "editTrades");
        }
    }

    private void AddTrade() {
        ((BasicTradeEditTab)this.commonTab).addTrade();
    }

    private void RemoveTrade() {
        ((BasicTradeEditTab)this.commonTab).removeTrade();
    }
}

