/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.tax_collector;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.taxes.ITaxable;
import io.github.lightman314.lightmanscurrency.api.taxes.reference.TaxableReference;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.menus.tax_collector.TaxCollectorClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.tax_collector.tabs.InfoTab;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import io.github.lightman314.lightmanscurrency.common.taxes.data.TaxStats;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class InfoClientTab
extends TaxCollectorClientTab<InfoTab> {
    public InfoClientTab(Object screen, InfoTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconUtil.ICON_TRADER;
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return LCText.TOOLTIP_TAX_COLLECTOR_INFO.get(new Object[0]);
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        MutableComponent clearLabel = LCText.BUTTON_TAX_COLLECTOR_STATS_CLEAR.get(new Object[0]);
        int buttonWidth = this.getFont().width((FormattedText)clearLabel) + 6;
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(screenArea.width - buttonWidth - 8, 15))).size(buttonWidth, 12)).text((Component)clearLabel).pressAction(((InfoTab)this.commonTab)::ClearInfoCache)).addon(EasyAddonHelper.visibleCheck(this::canClearStats))).build());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString(this.getTooltip(), 8, 6, 0x404040);
        TaxEntry entry = this.getEntry();
        if (entry != null) {
            ITaxable taxable;
            TaxStats stats = entry.stats;
            gui.drawString((Component)LCText.GUI_TAX_COLLECTOR_STATS_TOTAL_COLLECTED.get(new Object[0]), 10, 35, 0x404040);
            gui.drawString(stats.getTotalCollected().getRandomValueText(), 10, 45, 0x404040);
            gui.drawString((Component)LCText.GUI_TAX_COLLECTOR_STATS_UNIQUE_TAXABLES.get(stats.getUniqueTaxableCount()), 10, 65, 0x404040);
            TaxableReference mostTaxed = stats.getMostTaxed();
            gui.drawString((Component)LCText.GUI_TAX_COLLECTOR_STATS_MOST_TAXED_LABEL.get(new Object[0]), 10, 85, 0x404040);
            if (mostTaxed != null && (taxable = mostTaxed.getTaxable(true)) != null) {
                gui.drawString((Component)taxable.getName(), 10, 95, 0x404040);
                gui.drawString((Component)LCText.GUI_TAX_COLLECTOR_STATS_MOST_TAXED_FORMAT.get(stats.getMostTaxedCount()), 10, 104, 0x404040);
            }
        }
    }

    private boolean canClearStats() {
        return ((InfoTab)this.commonTab).CanClearCache(this.getEntry());
    }
}

