/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.api.trader_interface.menu.TraderInterfaceTab;
import io.github.lightman314.lightmanscurrency.client.gui.easy.tabbed.EasyTabbedMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.util.IWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.WidgetRotation;
import io.github.lightman314.lightmanscurrency.client.gui.widget.util.LazyWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class TraderInterfaceScreen
extends EasyTabbedMenuScreen<TraderInterfaceMenu, TraderInterfaceTab, TraderInterfaceScreen> {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/container/trader_interface.png");
    public static final int WIDTH = 206;
    public static final int HEIGHT = 236;
    IconButton modeToggle;
    IconButton onlineModeToggle;

    public TraderInterfaceScreen(TraderInterfaceMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.resize(206, 236);
    }

    @Override
    @Nonnull
    protected IWidgetPositioner getTabButtonPositioner() {
        return LazyWidgetPositioner.create(this, LazyWidgetPositioner.createLeftRight(WidgetRotation.TOP), ScreenPosition.of(0, -25), 25);
    }

    @Override
    public void init(ScreenArea screenArea) {
        this.modeToggle = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width, 0))).pressAction(this::ToggleMode)).icon(() -> IconUtil.GetIcon(this.getMode())).addon(EasyAddonHelper.tooltip(() -> this.getMode().getDisplayText()))).build());
        this.onlineModeToggle = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width, 20))).pressAction(this::ToggleOnlineMode)).icon(() -> ((TraderInterfaceMenu)this.menu).getBE().isOnlineMode() ? IconUtil.ICON_ONLINEMODE_TRUE : IconUtil.ICON_ONLINEMODE_FALSE).addon(EasyAddonHelper.tooltip(() -> ((TraderInterfaceMenu)this.menu).getBE().isOnlineMode() ? LCText.TOOLTIP_INTERFACE_ONLINE_MODE_ON.get(new Object[0]) : LCText.TOOLTIP_INTERFACE_ONLINE_MODE_OFF.get(new Object[0])))).build());
        this.currentTab().onOpen();
        this.containerTick();
    }

    @Override
    protected void renderBackground(@Nonnull EasyGuiGraphics gui) {
        gui.renderNormalBackground(GUI_TEXTURE, this);
        gui.drawString(this.playerInventoryTitle, 23, this.getYSize() - 94, 0x404040);
    }

    @Override
    public void screenTick() {
        if (!((TraderInterfaceTab)this.currentTab().commonTab).canOpen(((TraderInterfaceMenu)this.menu).player)) {
            this.changeTab(0);
        }
    }

    private TraderInterfaceBlockEntity.ActiveMode getMode() {
        if (((TraderInterfaceMenu)this.menu).getBE() != null) {
            return ((TraderInterfaceMenu)this.menu).getBE().getMode();
        }
        return TraderInterfaceBlockEntity.ActiveMode.DISABLED;
    }

    private void ToggleMode(EasyButton button) {
        ((TraderInterfaceMenu)this.menu).changeMode(this.getMode().getNext());
    }

    private void ToggleOnlineMode(EasyButton button) {
        ((TraderInterfaceMenu)this.menu).setOnlineMode(!((TraderInterfaceMenu)this.menu).getBE().isOnlineMode());
    }

    @Override
    public boolean blockInventoryClosing() {
        return this.currentTab().blockInventoryClosing();
    }

    public void changeTab(int newTab) {
        this.changeTab(newTab, true);
    }

    public void changeTab(int newTab, boolean sendMessage) {
        ((TraderInterfaceMenu)this.menu).ChangeTab(newTab);
    }
}

