/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.rules;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public final class TradeRuleType<T extends TradeRule> {
    public final ResourceLocation type;
    private final Supplier<T> generator;

    public TradeRuleType(@Nonnull ResourceLocation type, @Nonnull Supplier<T> generator) {
        this.type = type;
        this.generator = generator;
    }

    @Nonnull
    public T createNew() {
        return (T)((TradeRule)this.generator.get());
    }

    public T load(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider lookup) {
        try {
            T rule = this.createNew();
            ((TradeRule)rule).load(tag, lookup);
            return rule;
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error loading Trade Rule!", t);
            return null;
        }
    }

    public T loadFromJson(@Nonnull JsonObject json, @Nonnull HolderLookup.Provider lookup) throws JsonSyntaxException, ResourceLocationException {
        T rule = this.createNew();
        ((TradeRule)rule).loadFromJson(json, lookup);
        ((TradeRule)rule).setActive(true);
        return rule;
    }

    public String toString() {
        return this.type.toString();
    }
}

