/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.blocks;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.api.ejection.SafeEjectionAPI;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IEasyEntityBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.LazyShapes;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderState;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.api.traders.blocks.ITraderBlock;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeable;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeableBlock;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeableBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.CapabilityInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.EasyBlock;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.TraderEjectionData;
import io.github.lightman314.lightmanscurrency.common.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockEntityValidator;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class TraderBlockBase
extends EasyBlock
implements ITraderBlock,
IEasyEntityBlock,
IUpgradeableBlock {
    private final VoxelShape shape;

    public TraderBlockBase(BlockBehaviour.Properties properties) {
        this(properties, LazyShapes.BOX);
    }

    public TraderBlockBase(BlockBehaviour.Properties properties, VoxelShape shape) {
        super(properties);
        this.shape = shape != null ? shape : LazyShapes.BOX;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.shape;
    }

    protected boolean shouldMakeTrader(BlockState state) {
        return true;
    }

    protected abstract BlockEntity makeTrader(BlockPos var1, BlockState var2);

    protected BlockEntity makeDummy(BlockPos pos, BlockState state) {
        return new CapabilityInterfaceBlockEntity(pos, state);
    }

    protected abstract BlockEntityType<?> traderType();

    protected List<BlockEntityType<?>> validTraderTypes() {
        return ImmutableList.of(this.traderType());
    }

    @Override
    @Nonnull
    public Collection<BlockEntityType<?>> getAllowedTypes() {
        return this.validTraderTypes();
    }

    public final BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        if (this.shouldMakeTrader(state)) {
            return this.makeTrader(pos, state);
        }
        return this.makeDummy(pos, state);
    }

    @Nonnull
    public InteractionResult useWithoutItem(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull BlockHitResult result) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos)) instanceof TraderBlockEntity) {
            TraderBlockEntity traderSource = (TraderBlockEntity)blockEntity;
            Object trader = traderSource.getTraderData();
            if (trader == null) {
                LightmansCurrency.LogWarning("Trader Data for block at " + pos.getX() + "," + pos.getY() + "," + pos.getZ() + " had to be re-initialized on interaction.");
                player.sendSystemMessage((Component)LCText.MESSAGE_TRADER_WARNING_MISSING_DATA.getWithStyle(ChatFormatting.RED));
                traderSource.initialize(player, ItemStack.EMPTY);
                trader = traderSource.getTraderData();
            }
            if (trader != null) {
                if (((TraderData)trader).getState() == TraderState.EJECTED) {
                    LightmansCurrency.LogWarning("Trader was somehow flagged as ejected, yet it is still present in the world!\nFlagging trader as 'normal'");
                    ((TraderData)trader).move(level, blockEntity.getBlockPos());
                    ((TraderData)trader).setState(TraderState.NORMAL);
                    for (EjectionData data : SafeEjectionAPI.getApi().getAllData(false)) {
                        TraderEjectionData d;
                        if (!(data instanceof TraderEjectionData) || (d = (TraderEjectionData)data).getTraderID() != ((TraderData)trader).getID()) continue;
                        d.delete();
                    }
                }
                if (((TraderData)trader).shouldAlwaysShowOnTerminal() && ((TraderData)trader).hasPermission(player, "openStorage")) {
                    ((TraderData)trader).openStorageMenu(player, BlockEntityValidator.of(traderSource));
                } else {
                    ((TraderData)trader).openTraderMenu(player, BlockEntityValidator.of(traderSource));
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void setPlacedBy(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity player, @Nonnull ItemStack stack) {
        this.setPlacedByBase(level, pos, state, player, stack);
    }

    public final void setPlacedByBase(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            BlockEntity blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos);
            if (blockEntity instanceof TraderBlockEntity) {
                TraderBlockEntity traderSource = (TraderBlockEntity)blockEntity;
                traderSource.initialize(player, stack);
            } else {
                LightmansCurrency.LogError("Trader Block returned block entity of type '" + (blockEntity == null ? "null" : blockEntity.getClass().getName()) + "' when placing the block.");
            }
        }
        this.tryCopyVariant(level, pos, stack);
    }

    @Nonnull
    public BlockState playerWillDestroy(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        this.playerWillDestroyBase(level, pos, state, player);
        return state;
    }

    public final void playerWillDestroyBase(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos);
        if (blockEntity instanceof TraderBlockEntity) {
            TraderBlockEntity traderSource = (TraderBlockEntity)blockEntity;
            if (!traderSource.canBreak(player)) {
                return;
            }
            traderSource.flagAsLegitBreak();
            Object trader = traderSource.getTraderData();
            if (trader != null) {
                InventoryUtil.dumpContents(level, pos, ((TraderData)trader).getContents(level, pos, state, !player.isCreative()));
            }
        } else {
            LightmansCurrency.LogError("Trader Block returned block entity of type '" + (blockEntity == null ? "null" : blockEntity.getClass().getName()) + "' when destroying the block.");
        }
        super.playerWillDestroy(level, pos, state, player);
    }

    public void onRemove(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean flag) {
        BlockEntity blockEntity;
        if (state.is(newState.getBlock())) {
            super.onRemove(state, level, pos, newState, flag);
            return;
        }
        if (!level.isClientSide && (blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos)) instanceof TraderBlockEntity) {
            TraderBlockEntity traderSource = (TraderBlockEntity)blockEntity;
            if (traderSource.isSelfPickup()) {
                super.onRemove(state, level, pos, newState, flag);
                return;
            }
            if (!traderSource.legitimateBreak()) {
                traderSource.flagAsPickup();
                Object trader = traderSource.getTraderData();
                if (trader != null && ((TraderData)trader).getState().shouldEject()) {
                    if (!((Boolean)LCConfig.SERVER.anarchyMode.get()).booleanValue()) {
                        LightmansCurrency.LogError("Trader block at " + pos.getX() + " " + pos.getY() + " " + pos.getZ() + " was broken by illegal means!");
                        LightmansCurrency.LogError("Activating emergency eject protocol.");
                    }
                    EjectionData data = ((TraderData)trader).buildEjectionData(level, pos, state);
                    SafeEjectionAPI.getApi().handleEjection(level, pos, data);
                }
                this.onInvalidRemoval(state, level, pos, (TraderData)trader);
                this.removeOtherBlocks(level, state, pos);
            } else {
                LightmansCurrency.LogDebug("Trader block was broken by legal means!");
                traderSource.onBreak();
            }
        }
        super.onRemove(state, level, pos, newState, flag);
    }

    public final void removeAllBlocks(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockPos pos) {
        this.setAir(level, pos, null);
        this.removeOtherBlocks(level, state, pos);
    }

    public void removeOtherBlocks(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockPos pos) {
    }

    protected void onInvalidRemoval(BlockState state, Level level, BlockPos pos, TraderData trader) {
    }

    public boolean canEntityDestroy(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        return false;
    }

    protected Supplier<List<Component>> getItemTooltips() {
        return ArrayList::new;
    }

    @Override
    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        TooltipItem.addTooltip(tooltip, this.getItemTooltips());
        super.appendHoverText(stack, context, tooltip, flag);
    }

    protected static void replaceTraderBlock(Level level, BlockPos pos, BlockState newState) {
        level.setBlock(pos, newState, 35);
    }

    protected final void setAir(Level level, BlockPos pos, Player player) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() == this) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 35);
            if (player != null) {
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
            }
        }
    }

    @Override
    @Nullable
    public IUpgradeable getUpgradeable(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        BlockEntity blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos);
        if (blockEntity instanceof IUpgradeableBlockEntity) {
            IUpgradeableBlockEntity be = (IUpgradeableBlockEntity)blockEntity;
            return be.getUpgradeable();
        }
        return null;
    }

    @Override
    public boolean canUseUpgradeItem(@Nonnull IUpgradeable upgradeable, @Nonnull ItemStack stack, @Nullable Player player) {
        if (upgradeable instanceof TraderData) {
            TraderData trader = (TraderData)upgradeable;
            return player != null && trader.hasPermission(player, "openStorage");
        }
        return false;
    }
}

